/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.http;

import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    public static final String CHARSET = "UTF-8";

    public static CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static String doGet(String url, Map<String, String> params) {
        return HttpClientUtils.doGet(url, params, CHARSET);
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpClientUtils.doPost(url, params, CHARSET);
    }

    public static String doGet(String url, Map<String, String> params, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPost(String url, Map<String, String> params, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            CloseableHttpClient httpClient;
            CloseableHttpResponse response;
            int statusCode;
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            if ((statusCode = (response = (httpClient = HttpClientUtils.getHttpClient()).execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doJsonPost(String url, Map<String, String> params, String charset) throws Exception {
        Gson gson = new Gson();
        String jsonPost = gson.toJson(params);
        HttpPost httpPost = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(jsonPost, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)requestEntity);
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity responseEntity = response.getEntity();
            String result = null;
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)charset);
            }
            EntityUtils.consume((HttpEntity)responseEntity);
            String string = result;
            return string;
        }
    }

    public static String doPost(String url, Map<String, String> params, Map<String, File> files) {
        CloseableHttpResponse response = null;
        try {
            logger.trace("doPost - start, url:{}", (Object)url);
            long start = System.currentTimeMillis();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(60000).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            long end = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: get httpClinet, cost:{}", (Object)(end - start));
            HttpPost httpPost = new HttpPost(url);
            MultipartEntity multipartEntity = new MultipartEntity();
            long getPostTime = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: getHttppOST cost:{}", (Object)(getPostTime - end));
            for (Map.Entry<String, File> entry : files.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new FileBody(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)multipartEntity);
            logger.trace("doPost - execute, url:{}", (Object)url);
            response = httpClient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            logger.trace("doPost - execute end, url:{}, status:{}", (Object)url, (Object)statusLine);
            HttpEntity responseEntity = response.getEntity();
            String responseCont = EntityUtils.toString((HttpEntity)responseEntity, (String)CHARSET);
            EntityUtils.consume((HttpEntity)responseEntity);
            logger.debug("doPost - url:{}, status:{}, response:{}", new Object[]{url, statusLine, responseCont});
            return responseCont;
        }
        catch (Exception e) {
            throw new RuntimeException("dopost exception - ", e);
        }
    }

    public static String doJsonPost(String url, Object params, String charset) throws Exception {
        Gson gson = new Gson();
        String jsonPost = gson.toJson(params);
        HttpPost httpPost = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(jsonPost, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)requestEntity);
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity responseEntity = response.getEntity();
            String result = null;
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)charset);
            }
            EntityUtils.consume((HttpEntity)responseEntity);
            String string = result;
            return string;
        }
    }
}

