/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FileUtils {
    public static boolean mkdir(String f) throws Exception {
        File file = new File(f);
        file.mkdir();
        return true;
    }

    public static boolean delete(String f) throws Exception {
        File file = new File(f);
        file.delete();
        return true;
    }

    public static String read(String file) throws Exception {
        return FileUtils.read(file, System.getProperty("file.encoding"));
    }

    public static String read(String file, String encoding) throws Exception {
        return FileUtils.read(new FileInputStream(file), encoding);
    }

    public static String read(InputStream in) throws Exception {
        return FileUtils.read(in, System.getProperty("file.encoding"));
    }

    public static String read(InputStream in, String encoding) throws Exception {
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            bis = new BufferedInputStream(in);
            baos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((len = bis.read(b)) >= 0) {
                baos.write(b, 0, len);
            }
            String string = new String(baos.toByteArray(), encoding);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static byte[] readBytes(InputStream in) throws Exception {
        ByteArrayOutputStream baos = null;
        byte[] b = new byte[1024];
        int len = 0;
        try {
            baos = new ByteArrayOutputStream();
            while ((len = in.read(b)) > 0) {
                baos.write(b, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
    }

    public static boolean write(String f, String s, boolean append) throws Exception {
        return FileUtils.write(f, s.getBytes(), append);
    }

    public static boolean write(String f, String s) throws Exception {
        return FileUtils.write(f, s.getBytes(), false);
    }

    public static boolean write(String f, byte[] b) throws Exception {
        return FileUtils.write(f, b, false);
    }

    public static boolean write(String f, byte[] b, boolean append) throws Exception {
        try (FileOutputStream fos = null;){
            String path = FileUtils.getFilePath(f);
            if (path.equals("")) {
                throw new IllegalArgumentException("invalid file path: " + f);
            }
            File pathFile = new File(path);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            fos = new FileOutputStream(f, append);
            fos.write(b);
            return true;
        }
    }

    public static String getLowercaseExt(String file) {
        return FileUtils.getExt(file).toLowerCase();
    }

    public static String getExt(String file) {
        String ext = "";
        int idx = file.lastIndexOf(".");
        if (idx > 0) {
            ext = new String(file.substring(idx + 1)).trim();
        }
        return ext;
    }

    public static String getFilePath(String f) {
        String path = "";
        int idx = f.lastIndexOf(File.separator);
        if (idx > 0) {
            path = new String(f.substring(0, idx)).trim();
        }
        return path;
    }

    public static boolean exists(String f) {
        File file = new File(f);
        return file.exists();
    }
}

