/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.file;

import com.baijia.commons.lang.utils.file.FileChangedCallback;
import com.baijia.commons.lang.utils.file.FileChangedEvent;
import com.baijia.commons.lang.utils.file.FileChangedType;
import com.baijia.commons.lang.utils.file.FolderChangedEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public class FileChangedWatcher {
    private static final FileChangedWatcher WATCHER = new FileChangedWatcher();
    private final Map<File, List<FileChangedCallback>> callbacksByFile = new ConcurrentHashMap<File, List<FileChangedCallback>>();
    private final Map<File, Long> lastModifyOfFile = new ConcurrentHashMap<File, Long>();
    private final Map<File, List<File>> filesOfFolder = new ConcurrentHashMap<File, List<File>>();
    private static final String CLASS_PATH_PREFIX = "classpath:";
    private long period = TimeUnit.SECONDS.toMillis(1L);
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2);

    private FileChangedWatcher() {
        this.executorService.scheduleAtFixedRate(new Worker(), 0L, this.period, TimeUnit.MILLISECONDS);
    }

    public void setPeriod(long period) {
        this.period = period;
        this.executorService.shutdown();
        this.executorService = Executors.newScheduledThreadPool(2);
    }

    public long getPeriod() {
        return this.period;
    }

    public static FileChangedWatcher getInstance() {
        return WATCHER;
    }

    public void watchFile(String file, FileChangedCallback callback) {
        assert (file != null && file.trim().length() > 0);
        File f = FileChangedWatcher.getAbsoluteFile(file);
        if (f.isDirectory()) {
            if (!this.filesOfFolder.containsKey(f)) {
                this.filesOfFolder.put(f, new CopyOnWriteArrayList());
            }
            Collection subFiles = FileUtils.listFiles((File)f, null, (boolean)true);
            this.filesOfFolder.get(f).addAll(subFiles);
            for (File subFile : subFiles) {
                this.updateLastModify(subFile, subFile.lastModified());
            }
        }
        this.updateLastModify(f, f.lastModified());
        this.registWatcher(f, callback);
    }

    public void unwatchFile(String file, FileChangedCallback callback) {
        assert (file != null && file.trim().length() > 0);
        File f = FileChangedWatcher.getAbsoluteFile(file);
        this.removeLastModify(f);
        this.unregistWatcher(f, callback);
    }

    private void registWatcher(File f, FileChangedCallback callback) {
        if (!this.callbacksByFile.containsKey(f)) {
            this.callbacksByFile.put(f, new CopyOnWriteArrayList());
        }
        this.callbacksByFile.get(f).add(callback);
    }

    private void unregistWatcher(File f, FileChangedCallback callback) {
        if (this.callbacksByFile.containsKey(f)) {
            if (callback == null) {
                this.callbacksByFile.remove(f);
            } else {
                this.callbacksByFile.get(f).remove(callback);
            }
        }
    }

    private void updateLastModify(File f, Long lastModify) {
        this.lastModifyOfFile.put(f, lastModify == null ? Long.MIN_VALUE : lastModify);
    }

    private void removeLastModify(File f) {
        this.lastModifyOfFile.remove(f);
    }

    public static File getAbsoluteFile(String file) {
        File f = new File(file);
        if (file.toLowerCase().startsWith(CLASS_PATH_PREFIX) || !f.isAbsolute()) {
            String filename = file.replace(CLASS_PATH_PREFIX, "");
            f = new File(String.valueOf(Thread.currentThread().getContextClassLoader().getResource("").getPath()) + filename);
        }
        return f;
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        private void triggerFileChange(File file, FileChangedType type) {
            FileChangedWatcher.this.lastModifyOfFile.put(file, file.lastModified());
            for (FileChangedCallback callback : (List)FileChangedWatcher.this.callbacksByFile.get(file)) {
                callback.fileChanged(new FileChangedEvent(type, file));
            }
        }

        @Override
        public void run() {
            for (File file : FileChangedWatcher.this.callbacksByFile.keySet()) {
                if (file.isDirectory()) {
                    List subFiles = (List)FileChangedWatcher.this.filesOfFolder.get(file);
                    FolderChangedEvent event = new FolderChangedEvent(file, new HashMap<File, FileChangedType>());
                    for (File subFile : subFiles) {
                        if (subFile.lastModified() <= (Long)FileChangedWatcher.this.lastModifyOfFile.get(subFile)) continue;
                        event.addChangedFile(subFile, FileChangedType.edit);
                        FileChangedWatcher.this.updateLastModify(subFile, subFile.lastModified());
                    }
                    Collection filesNow = FileUtils.listFiles((File)file, null, (boolean)true);
                    ArrayList tmp = new ArrayList(filesNow);
                    filesNow.removeAll(subFiles);
                    if (!filesNow.isEmpty()) {
                        for (File file2 : filesNow) {
                            FileChangedWatcher.this.updateLastModify(file2, file2.lastModified());
                            event.addChangedFile(file2, FileChangedType.add);
                        }
                        ((List)FileChangedWatcher.this.filesOfFolder.get(file)).addAll(filesNow);
                    }
                    ArrayList tmp2 = new ArrayList(subFiles);
                    tmp2.removeAll(tmp);
                    if (!tmp2.isEmpty()) {
                        for (File file2 : tmp2) {
                            FileChangedWatcher.this.removeLastModify(file2);
                            FileChangedWatcher.this.unregistWatcher(file2, null);
                            event.addChangedFile(file2, FileChangedType.delete);
                        }
                        ((List)FileChangedWatcher.this.filesOfFolder.get(file)).removeAll(tmp2);
                    }
                    if (event.getChangeTypeOfFile().isEmpty()) continue;
                    for (FileChangedCallback callback : (List)FileChangedWatcher.this.callbacksByFile.get(file)) {
                        callback.folderChanged(event);
                    }
                    continue;
                }
                if (file.lastModified() > 0L) {
                    if ((Long)FileChangedWatcher.this.lastModifyOfFile.get(file) <= 0L) {
                        this.triggerFileChange(file, FileChangedType.add);
                        continue;
                    }
                    if (file.lastModified() <= (Long)FileChangedWatcher.this.lastModifyOfFile.get(file)) continue;
                    this.triggerFileChange(file, FileChangedType.edit);
                    continue;
                }
                if (!FileChangedWatcher.this.callbacksByFile.containsKey(file)) continue;
                this.triggerFileChange(file, FileChangedType.delete);
                FileChangedWatcher.this.unregistWatcher(file, null);
                FileChangedWatcher.this.removeLastModify(file);
            }
        }
    }
}

