/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.excel;

import com.baijia.commons.lang.utils.excel.ExcelCell;
import com.baijia.commons.lang.utils.excel.ExcelCellStyle;
import com.baijia.commons.lang.utils.excel.Excelable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static Workbook createWorkbook() {
        return new HSSFWorkbook();
    }

    public static <A> void exportToExcel(OutputStream output, String sheetName, List<A> datas, Excelable<A> exporter) {
        Workbook wb = ExcelUtils.createWorkbook();
        ExcelUtils.createSheet(wb, sheetName, datas, exporter);
        ExcelUtils.exportToExcel(output, wb);
        try {
            wb.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exportToExcel(OutputStream output, Workbook wb) {
        block2: {
            try {
                wb.write(output);
            }
            catch (IOException e) {
                String simplename = e.getClass().getSimpleName();
                if (!"ClientAbortException".equals(simplename)) break block2;
                log.warn("Error while exporting data.And it's a ClientAbortException");
            }
        }
    }

    public static Sheet createSheet(Workbook wb, String sheetName) {
        Sheet sheet = sheetName != null ? wb.createSheet(sheetName) : wb.createSheet();
        return sheet;
    }

    public static <A> Sheet export2Sheet(Sheet sheet, List<A> datas, Excelable<A> exporter) {
        int maxColumnNum = 0;
        ExcelCell[] excelCellArray = exporter.exportRowName();
        int n = excelCellArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExcelCell excelCell = excelCellArray[n2];
            maxColumnNum = Math.max(maxColumnNum, excelCell.getColumnNumOffset() + excelCell.getColumnSize());
            ++n2;
        }
        int i = 0;
        while (i < maxColumnNum) {
            sheet.setColumnWidth(i, 5120);
            ++i;
        }
        List<ExcelCell[]> result = ExcelUtils.preprocessData(datas, exporter);
        int size = result.size();
        int rowNumAnchor = 0;
        HashMap<ExcelCellStyle, CellStyle> styleMap = new HashMap<ExcelCellStyle, CellStyle>();
        int i2 = 0;
        while (i2 < size) {
            ExcelUtils.createRow(sheet, rowNumAnchor, result.get(i2), styleMap);
            rowNumAnchor += ExcelUtils.getMaxRowSize(result.get(i2));
            ++i2;
        }
        return sheet;
    }

    public static <A> Sheet createSheet(Workbook wb, String sheetName, List<A> datas, Excelable<A> exporter) {
        return ExcelUtils.export2Sheet(ExcelUtils.createSheet(wb, sheetName), datas, exporter);
    }

    private static int getMaxRowSize(ExcelCell[] values) {
        int maxRowSize = 0;
        ExcelCell[] excelCellArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ExcelCell excelCell = excelCellArray[n2];
            int rowSize = excelCell.getRowNumOffset() + excelCell.getRowSize();
            if (rowSize > maxRowSize) {
                maxRowSize = rowSize;
            }
            ++n2;
        }
        return maxRowSize;
    }

    public static <A> List<ExcelCell[]> preprocessData(List<A> datas, Excelable<A> exporter) {
        ArrayList<ExcelCell[]> result = new ArrayList<ExcelCell[]>(datas.size() + 1);
        result.add(exporter.exportRowName());
        if (datas != null) {
            for (A data : datas) {
                result.add(exporter.exportRowValue(data));
            }
        }
        return result;
    }

    public static void createRow(Sheet sheet, int rowNumAnchor, ExcelCell[] values, Map<ExcelCellStyle, CellStyle> styleMap) {
        Workbook wb = sheet.getWorkbook();
        Drawing p = sheet.createDrawingPatriarch();
        HashMap mapByRowNum = Maps.newHashMap();
        ExcelCell[] excelCellArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ExcelCell value = excelCellArray[n2];
            mapByRowNum.computeIfAbsent(value.getRowNumOffset(), k -> Lists.newArrayList()).add(value);
            ++n2;
        }
        mapByRowNum.entrySet().forEach(entry -> {
            int rowNum = rowNumAnchor + (Integer)entry.getKey();
            Row row = sheet.createRow(rowNum);
            for (ExcelCell excelCell : (List)entry.getValue()) {
                ExcelCellStyle excelCellStyle;
                if (excelCell == null) continue;
                int columnNum = excelCell.getColumnNumOffset();
                Cell cell = row.createCell(columnNum);
                ExcelUtils.fitCellValueByCellType(cell, excelCell);
                if (!StringUtils.isBlank((CharSequence)excelCell.getComment())) {
                    cell.setCellComment(ExcelUtils.createCellComment(p, excelCell, (short)columnNum, rowNum));
                }
                if ((excelCellStyle = excelCell.getCellStyle()) != null) {
                    CellStyle cellStyle = (CellStyle)styleMap.get(excelCellStyle);
                    if (cellStyle == null) {
                        cellStyle = wb.createCellStyle();
                        styleMap.put(excelCellStyle, cellStyle);
                        Font font = null;
                        if (excelCellStyle.getAlignment() != null) {
                            cellStyle.setAlignment(excelCellStyle.getAlignment().shortValue());
                        }
                        if (excelCellStyle.getVerticalAlignment() != null) {
                            cellStyle.setVerticalAlignment(excelCellStyle.getVerticalAlignment().shortValue());
                        }
                        if (excelCellStyle.getFontColor() != null) {
                            if (font == null) {
                                font = wb.createFont();
                            }
                            font.setColor(excelCellStyle.getFontColor().shortValue());
                        }
                        if (excelCellStyle.getBoldWeight() != null) {
                            if (font == null) {
                                font = wb.createFont();
                            }
                            font.setBoldweight(excelCellStyle.getBoldWeight().shortValue());
                        }
                        if (font != null) {
                            cellStyle.setFont(font);
                        }
                    }
                    cell.setCellStyle(cellStyle);
                }
                if (excelCell.getRowSize() <= 1 && excelCell.getColumnSize() <= 1) continue;
                sheet.addMergedRegion(new CellRangeAddress(rowNum, rowNum + excelCell.getRowSize() - 1, columnNum, columnNum + excelCell.getColumnSize() - 1));
            }
        });
    }

    private static void fitCellValueByCellType(Cell cell, ExcelCell value) {
        Integer cellType = value.getCellType();
        Object val = value.getValue();
        if (cellType == null) {
            cellType = 1;
        }
        if (cellType == 0) {
            cell.setCellType(0);
            if (Number.class.isInstance(val)) {
                cell.setCellValue(Double.valueOf(val.toString()).doubleValue());
            } else {
                cell.setCellValue(0.0);
            }
        } else {
            cell.setCellType(1);
            cell.setCellValue(val.toString());
        }
    }

    public static Comment createCellComment(Drawing draw, ExcelCell value, short col, int row) {
        short col2 = col;
        int row2 = row;
        col2 = (short)(col2 + 1);
        ++row2;
        int len = 0;
        try {
            len = value.getComment().getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (len > 24) {
            col2 = (short)(col + 3);
            row2 = row + (len - 1) / 24 + 1;
        } else {
            col2 = (short)(col + (len + 2) / 9 + 1);
        }
        Comment comment = draw.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 127, col, row, col2, row2));
        comment.setString((RichTextString)new HSSFRichTextString(value.getComment()));
        comment.setVisible(value.getIsCommentVisible());
        return comment;
    }

    public static void setSimpleCellColumnOffset(ExcelCell[] excelCells) {
        int i = 0;
        while (i < excelCells.length) {
            excelCells[i].setColumnNumOffset(i);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream os = new FileOutputStream("/Users/purerboy/works/temp/export.xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        Row row = sheet.createRow(1);
        Cell cell = row.createCell(1);
        cell.setCellValue("row merge");
        sheet.addMergedRegion(new CellRangeAddress(1, 2, 1, 1));
        cell = row.createCell(0);
        cell.setCellValue("10");
        row = sheet.createRow(2);
        cell = row.createCell(0);
        cell.setCellValue("20");
        sheet = wb.createSheet();
        row = sheet.createRow(0);
        cell = row.createCell(0);
        cell.setCellValue("col merge");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));
        sheet.setColumnWidth(0, 15360);
        wb.write((OutputStream)os);
        wb.close();
        ((OutputStream)os).close();
    }
}

