/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.excel;

import com.baijia.commons.lang.utils.excel.ExcelCell;
import com.baijia.commons.lang.utils.excel.ExcelCellStyle;
import com.baijia.commons.lang.utils.excel.ExcelUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExcelCellFactory {
    public static ExcelCell create() {
        return new ExcelCell();
    }

    public static ExcelCell create(Object value) {
        return ExcelCellFactory.create(value, null, null);
    }

    public static ExcelCell create(Object value, int cellType) {
        return ExcelCellFactory.create(value, cellType, null);
    }

    public static ExcelCell create(Object value, ExcelCellStyle cellStyle) {
        return ExcelCellFactory.create(value, null, cellStyle);
    }

    public static ExcelCell create(Object value, Integer cellType, ExcelCellStyle cellStyle) {
        ExcelCell cell = new ExcelCell();
        cell.setValue(value);
        cell.setCellType(cellType);
        cell.setCellStyle(cellStyle);
        return cell;
    }

    public static ExcelCell createHeadCell(Object value) {
        return ExcelCellFactory.create(value, ExcelCellStyle.HEAD_STYLE);
    }

    public static ExcelCell createExcelInteger(Integer value) {
        return ExcelCellFactory.createExcelInteger(value, 0);
    }

    public static ExcelCell createExcelInteger(Integer value, Integer defValue) {
        if (value == null) {
            return ExcelCellFactory.create(defValue);
        }
        return ExcelCellFactory.create(value);
    }

    public static ExcelCell createExcelDouble(Double value) {
        return ExcelCellFactory.createExcelDouble(value, 0.0);
    }

    public static ExcelCell createExcelDouble(Double value, Double defValue) {
        if (value == null) {
            return ExcelCellFactory.create(defValue);
        }
        return ExcelCellFactory.create(value);
    }

    public static ExcelCell createExcelDate(Date value) {
        return ExcelCellFactory.createExcelDate(value, null);
    }

    public static ExcelCell createExcelDate(Date value, SimpleDateFormat sdf) {
        if (value == null) {
            return ExcelCellFactory.create(null);
        }
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return ExcelCellFactory.create(sdf.format(value));
    }

    public static ExcelCell createExcelMoney(Double value) {
        return ExcelCellFactory.createExcelMoney(value, "\uffe5");
    }

    public static ExcelCell createExcelMoney(Double value, String prefix) {
        if (value == null) {
            value = 0.0;
        }
        if (prefix == null) {
            prefix = "";
        }
        return ExcelCellFactory.create(prefix + value);
    }

    public static ExcelCell[] createSimpleRow(ExcelCell ... excelCells) {
        ExcelUtils.setSimpleCellColumnOffset(excelCells);
        return excelCells;
    }

    public static ExcelCell[] createSimpleHeadRow(Object ... values) {
        ExcelCell[] excelCells = new ExcelCell[values.length];
        for (int i = 0; i < excelCells.length; ++i) {
            excelCells[i] = ExcelCellFactory.createHeadCell(values[i]);
        }
        ExcelUtils.setSimpleCellColumnOffset(excelCells);
        return excelCells;
    }
}

