/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.db;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbDocExporter {
    private static final Logger logger = LoggerFactory.getLogger(DbDocExporter.class);
    private DataSource ds;

    public DbDocExporter(DataSource ds) {
        this.ds = ds;
    }

    public void export(String database, String output) {
        logger.info("export - database:{}, output:{}", (Object)database, (Object)output);
        HashMap dbMeta = Maps.newHashMap();
        Map<String, TableMetaData> tableMetaDataMap = this.getTableMetaMap(database);
        for (Map.Entry<String, TableMetaData> entry : tableMetaDataMap.entrySet()) {
            TableMetaData tableMetaData = entry.getValue();
            List<ColumnMetaData> columnMetaList = this.getColumnMetaList(database, tableMetaData.getName());
            dbMeta.put(tableMetaData, columnMetaList);
        }
        this.generateDoc(dbMeta, output);
    }

    public void export(String database, List<String> tables, String output) {
        logger.info("export - database:{}, tables:{}, output:{}", new Object[]{database, tables, output});
        HashMap dbMeta = Maps.newHashMap();
        for (String table : tables) {
            Map<String, TableMetaData> tableMetaDataMap = this.getTableMeta(database, table);
            List<ColumnMetaData> columnMetaList = this.getColumnMetaList(database, table);
            dbMeta.put(tableMetaDataMap.get(table), columnMetaList);
        }
        this.generateDoc(dbMeta, output);
    }

    private void generateDoc(Map<TableMetaData, List<ColumnMetaData>> dbMeta, String outputFile) {
        OutputStream os = null;
        try {
            try {
                XWPFDocument doc = new XWPFDocument();
                for (Map.Entry<TableMetaData, List<ColumnMetaData>> entry : dbMeta.entrySet()) {
                    TableMetaData tableMeta = entry.getKey();
                    List<ColumnMetaData> columnMetaList = entry.getValue();
                    this.createNewLinePara(doc);
                    this.createTableTitlePara(doc, tableMeta);
                    XWPFTable docTable = this.createTable(doc, columnMetaList.size() + 1, 7);
                    XWPFTableRow headerRow = docTable.getRow(0);
                    this.setHeaderRowData(headerRow);
                    int i = 0;
                    while (i < columnMetaList.size()) {
                        XWPFTableRow row = docTable.getRow(i + 1);
                        this.setRowData(row, columnMetaList.get(i));
                        ++i;
                    }
                }
                os = new FileOutputStream(outputFile);
                doc.write(os);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private XWPFTable createTable(XWPFDocument doc, int rowCnt, int colCnt) {
        XWPFTable table = doc.createTable(rowCnt, colCnt);
        this.setTableProp(table);
        return table;
    }

    private void setTableProp(XWPFTable table) {
        CTTblPr prop = table.getCTTbl().addNewTblPr();
        CTTblWidth width = prop.addNewTblW();
        width.setW(BigInteger.valueOf(8000L));
    }

    private void createTableTitlePara(XWPFDocument doc, TableMetaData tableMeta) {
        XWPFParagraph para = doc.createParagraph();
        XWPFRun run = para.createRun();
        run.setBold(true);
        run.setText(String.valueOf(tableMeta.getTableType()) + ": " + tableMeta.getCategory() + "." + tableMeta.getName() + " (" + tableMeta.getRemarks() + ")");
    }

    private void createNewLinePara(XWPFDocument doc) {
        XWPFParagraph para = doc.createParagraph();
        XWPFRun run = para.createRun();
        run.setText("\n");
    }

    private void setHeaderRowData(XWPFTableRow row) {
        int j = 0;
        this.setCellData(row.getCell(j++), "\u540d\u79f0");
        this.setCellData(row.getCell(j++), "\u7c7b\u578b");
        this.setCellData(row.getCell(j++), "\u957f\u5ea6");
        this.setCellData(row.getCell(j++), "\u4e3a\u7a7a");
        this.setCellData(row.getCell(j++), "\u4e3b\u952e");
        this.setCellData(row.getCell(j++), "\u7f3a\u7701");
        this.setCellData(row.getCell(j++), "\u63cf\u8ff0");
    }

    private void setCellData(XWPFTableCell cell, String data) {
        this.setCellProp(cell, 1000);
        cell.setText(data);
    }

    private void setCellProp(XWPFTableCell cell, Integer width) {
        CTTcPr prop = cell.getCTTc().addNewTcPr();
        prop.addNewTcW().setW(BigInteger.valueOf(width.intValue()));
        prop.setNoWrap(CTOnOff.Factory.newInstance());
    }

    private void setRowData(XWPFTableRow row, ColumnMetaData columnMetaData) {
        Object[] cols = columnMetaData.getCols();
        int j = 0;
        while (j < cols.length) {
            XWPFTableCell cell = row.getCell(j);
            cell.setText(String.valueOf(cols[j]));
            ++j;
        }
    }

    private Map<String, TableMetaData> getTableMetaMap(String database) {
        return this.getTableMeta(database, null);
    }

    private Map<String, TableMetaData> getTableMeta(String database, String table) {
        HashMap result = Maps.newHashMap();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            DatabaseMetaData databaseMetaData = conn.getMetaData();
            rs = databaseMetaData.getTables(database, "", table, null);
            while (rs.next()) {
                String tableType = rs.getString("TABLE_TYPE");
                if (!tableType.equals("TABLE")) continue;
                String tableName = rs.getString("TABLE_NAME");
                TableMetaData metaData = new TableMetaData();
                metaData.setName(tableName);
                metaData.setTableType(tableType);
                metaData.setCategory(rs.getString("TABLE_CAT"));
                metaData.setTableType(rs.getString("TABLE_TYPE"));
                metaData.setRemarks(rs.getString("REMARKS"));
                result.put(tableName, metaData);
            }
            logger.info("db:{}, table:{}, result:{}", new Object[]{database, table, result});
            HashMap hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<ColumnMetaData> getColumnMetaList(String database, String table) {
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            DatabaseMetaData databaseMetaData = conn.getMetaData();
            rs = databaseMetaData.getColumns(database, "", table, null);
            ArrayList metaList = Lists.newArrayList();
            while (rs.next()) {
                Object[] cols = new Object[7];
                int i = 0;
                cols[i++] = rs.getString("COLUMN_NAME");
                cols[i++] = rs.getString("TYPE_NAME");
                cols[i++] = rs.getInt("COLUMN_SIZE");
                cols[i++] = rs.getString("IS_NULLABLE");
                cols[i++] = rs.getString("IS_AUTOINCREMENT");
                cols[i++] = rs.getString("COLUMN_DEF");
                cols[i++] = rs.getString("REMARKS");
                ColumnMetaData meta = new ColumnMetaData();
                meta.setCols(cols);
                metaList.add(meta);
            }
            logger.info("db:{}, table:{}, columns:{}", new Object[]{database, table, metaList});
            ArrayList arrayList = metaList;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class ColumnMetaData {
        private Object[] cols;

        private ColumnMetaData() {
        }

        public Object[] getCols() {
            return this.cols;
        }

        public void setCols(Object[] cols) {
            this.cols = cols;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }
    }

    private class TableMetaData {
        private String category;
        private String name;
        private String tableType;
        private String remarks;

        private TableMetaData() {
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTableType() {
            return this.tableType;
        }

        public void setTableType(String tableType) {
            this.tableType = tableType;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }
    }
}

