/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.date;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static Date getBeforeDate(Date baseDate, int delta) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        return new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5) - delta).getTime();
    }

    public static Date getNextDate(Date baseDate, int delta) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(baseDate);
        return new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5) + delta).getTime();
    }

    public static Date getToday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getBeginTimeOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0).getTime();
    }

    public static Date getEndTimeOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5), 23, 23, 59).getTime();
    }

    public static <T extends Date> boolean compareTo(T currTime, Date start, Date end) {
        return currTime.after(start) && currTime.before(end);
    }
}

