/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.concurrent;

import com.baijia.commons.lang.utils.ServiceLocator;
import com.baijia.commons.lang.utils.cache.redis.Heartbeat;
import com.baijia.commons.lang.utils.cache.redis.HeartbeatLock;
import com.baijia.commons.lang.utils.cache.redis.RedisUtil;
import com.baijia.commons.lang.utils.concurrent.SingletonTaskUtils;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SingletonTaskUtilsByHeartbeat {
    private static final Logger logger = LoggerFactory.getLogger(SingletonTaskUtilsByHeartbeat.class);
    private static int count = 0;

    public static void excuteSingletonTask(SingletonTaskUtils.CallBack callBack) {
        SingletonTaskUtilsByHeartbeat.excuteSingletonTask(callBack, RedisUtil.getIns(), Heartbeat.getMyHeartbeat());
    }

    public static void excuteSingletonTask(SingletonTaskUtils.CallBack callBack, RedisUtil redisUtil, Heartbeat heartbeat) {
        HeartbeatLock lock = new HeartbeatLock(redisUtil, callBack.taskName(), heartbeat);
        boolean locked = false;
        try {
            try {
                locked = lock.tryLock();
                if (locked) {
                    callBack.call();
                }
            }
            catch (Throwable e) {
                logger.error("excute task[" + callBack.taskName() + "] error...", e);
                lock.unlock(false);
            }
        }
        finally {
            lock.unlock(false);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("classpath:ctx-redis.xml");
        ServiceLocator locator = new ServiceLocator();
        locator.setApplicationContext((ApplicationContext)context);
        final LinkedList list = new LinkedList();
        int size = 100;
        final CountDownLatch latch = new CountDownLatch(size);
        int i = size;
        while (i > 0) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SingletonTaskUtils.AbstractCallBack call = new SingletonTaskUtils.AbstractCallBack(){

                        @Override
                        public void call() {
                            int n = count + 1;
                            count = n;
                            list.add(n);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    SingletonTaskUtilsByHeartbeat.excuteSingletonTask(call);
                    latch.countDown();
                }
            };
            Thread.sleep(10L);
            thread.start();
            --i;
        }
        latch.await();
        System.out.println(list.size());
        System.out.println(list.getLast());
    }
}

