/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.concurrent;

import com.baijia.commons.lang.utils.ServiceLocator;
import com.baijia.commons.lang.utils.cache.redis.RedisLock;
import com.baijia.commons.lang.utils.cache.redis.RedisUtil;
import com.baijia.commons.lang.utils.concurrent.SingletonTaskUtils;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SingletonTaskUtilsByExpire {
    private static final Logger logger = LoggerFactory.getLogger(SingletonTaskUtilsByExpire.class);
    private static final int DEF_EXPIRE_TIME = 600;
    private static int count = 0;

    public static void excuteSingletonTask(SingletonTaskUtils.CallBack callBack) {
        SingletonTaskUtilsByExpire.excuteSingletonTask(callBack, 600);
    }

    public static void excuteSingletonTask(SingletonTaskUtils.CallBack callBack, int expireTime) {
        RedisLock lock = new RedisLock(RedisUtil.getIns(), callBack.taskName(), callBack.taskName(), expireTime);
        boolean locked = false;
        try {
            try {
                locked = lock.tryLock();
                if (locked) {
                    callBack.call();
                }
            }
            catch (Throwable e) {
                logger.error("excute task[" + callBack.taskName() + "] error...", e);
                if (locked) {
                    lock.unlock(false);
                }
            }
        }
        finally {
            if (locked) {
                lock.unlock(false);
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("classpath:ctx-redis.xml");
        ServiceLocator locator = new ServiceLocator();
        locator.setApplicationContext((ApplicationContext)context);
        final LinkedList list = new LinkedList();
        int size = 10;
        final CountDownLatch latch = new CountDownLatch(size);
        final SingletonTaskUtils.AbstractCallBack call = new SingletonTaskUtils.AbstractCallBack(){

            @Override
            public void call() {
                int n = count + 1;
                count = n;
                list.add(n);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        Thread thread = null;
        int i = size;
        while (i > 0) {
            thread = new Thread(){

                @Override
                public void run() {
                    SingletonTaskUtilsByExpire.excuteSingletonTask(call);
                    latch.countDown();
                }
            };
            Thread.sleep(10L);
            thread.start();
            --i;
        }
        latch.await();
        System.out.println(list.size());
        System.out.println(list.getLast());
    }
}

