/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.concurrent;

import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonTaskUtils {
    private static final Logger logger = LoggerFactory.getLogger(SingletonTaskUtils.class);
    private static final ConcurrentHashMap<String, Boolean> taskHolder = new ConcurrentHashMap();

    public static void excuteSingletonTask(CallBack callBack) {
        block8: {
            boolean locked = false;
            try {
                try {
                    taskHolder.putIfAbsent(callBack.taskName(), false);
                    locked = taskHolder.replace(callBack.taskName(), false, true);
                    if (locked) {
                        callBack.call();
                        break block8;
                    }
                    logger.info("Thread:{}, excute task:{} skipped .", (Object)Thread.currentThread().getId(), (Object)callBack.taskName());
                }
                catch (Throwable e) {
                    logger.error("Thread:{}, excute task:{} error:{} ...", new Object[]{Thread.currentThread().getId(), callBack.taskName(), e});
                    if (locked) {
                        taskHolder.remove(callBack.taskName());
                        logger.info("Thread:{}, excute task:{} finished .", (Object)Thread.currentThread().getId(), (Object)callBack.taskName());
                    }
                }
            }
            finally {
                if (locked) {
                    taskHolder.remove(callBack.taskName());
                    logger.info("Thread:{}, excute task:{} finished .", (Object)Thread.currentThread().getId(), (Object)callBack.taskName());
                }
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        int i = 100;
        while (i > 0) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    AbstractCallBack call = new AbstractCallBack(){

                        @Override
                        public void call() {
                            int random = new Random().nextInt(2);
                            if (random < 1) {
                                throw new RuntimeException("Thread :" + Thread.currentThread().getId() + " throw exception");
                            }
                            logger.info("Thread running:" + Thread.currentThread().getId());
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    SingletonTaskUtils.excuteSingletonTask(call);
                }
            };
            Thread.sleep(10L);
            thread.start();
            --i;
        }
        while (true) {
            Thread.sleep(2000L);
        }
    }

    public static abstract class AbstractCallBack
    implements CallBack {
        @Override
        public String taskName() {
            return this.getClass().getName();
        }

        @Override
        public abstract void call();
    }

    public static interface CallBack {
        public String taskName();

        public void call();
    }
}

