/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    public static <K, E> List<K> extractList(Collection<E> objs, Extracter<K, E> extracter) {
        ArrayList<K> list = new ArrayList<K>();
        for (E obj : objs) {
            K key = extracter.extract(obj);
            list.add(key);
        }
        return list;
    }

    public static <K, E> Map<K, E> extractMap(Collection<E> objs, Extracter<K, E> extracter) {
        HashMap<K, E> map = new HashMap<K, E>();
        for (E obj : objs) {
            K key = extracter.extract(obj);
            map.put(key, obj);
        }
        return map;
    }

    public static <K, E> Map<K, List<E>> extractMappedList(Collection<E> objs, Extracter<K, E> extracter) {
        HashMap<K, LinkedList<E>> map = new HashMap<K, LinkedList<E>>();
        for (E obj : objs) {
            K key = extracter.extract(obj);
            LinkedList<E> items = (LinkedList<E>)map.get(key);
            if (items == null) {
                items = new LinkedList<E>();
                map.put(key, items);
            }
            items.add(obj);
        }
        return map;
    }

    public static <T> List<List<T>> split(Collection<T> orig, int batchSize) {
        if (orig == null || orig.isEmpty() || batchSize < 1) {
            return Collections.emptyList();
        }
        int size = orig.size();
        int len = CollectionUtils.calSplitLen(batchSize, size);
        ArrayList<List<T>> result = new ArrayList<List<T>>(len);
        ArrayList<T> list = null;
        list = orig instanceof List ? (ArrayList<T>)orig : new ArrayList<T>(orig);
        int i = 0;
        while (i < len) {
            result.add(new ArrayList(list.subList(i * batchSize, (i + 1) * batchSize < size ? (i + 1) * batchSize : size)));
            ++i;
        }
        return result;
    }

    public static <T, C extends Collection<T>> List<T> merge(Collection<C> splits) {
        if (splits == null || splits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (Collection split : splits) {
            list.addAll(split);
        }
        return list;
    }

    private static int calSplitLen(int batchSize, int size) {
        return (size - 1) / batchSize + 1;
    }

    public static interface Extracter<K, E> {
        public K extract(E var1);
    }
}

