/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.code;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeUtils {
    private static Logger logger = LoggerFactory.getLogger(QRCodeUtils.class);
    public static final int DEF_WIDTH = 800;
    public static final int DEF_HEIGHT = 800;
    public static final String DEF_FORMAT = "png";
    public static final int DEF_FRONT_COLOR = -16777201;
    public static final int DEF_BACKGROUND_COLOR = -1;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final String DEF_CHARSET = "UTF-8";
    public static final Map<EncodeHintType, Object> DEF_HINTS = Collections.unmodifiableMap(new HashMap<EncodeHintType, Object>(){
        private static final long serialVersionUID = -2814852094262448164L;
        {
            this.put(EncodeHintType.MARGIN, 1);
            this.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        }
    });
    private static final MultiFormatWriter factory = new MultiFormatWriter();

    public static void genQrCode(String contents, String fileName, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream bops = null;
        try {
            bops = new ByteArrayOutputStream();
            if (QRCodeUtils.genQrCode(contents, bops)) {
                response.setContentType("multipart/form-data");
                response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
                response.getOutputStream().write(bops.toByteArray());
            }
        }
        finally {
            if (bops != null) {
                try {
                    bops.close();
                }
                catch (Exception exception) {}
                bops = null;
            }
        }
    }

    public static void genQrCode(String contents, InputStream imageIn, String fileName, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream bops = null;
        try {
            bops = new ByteArrayOutputStream();
            if (QRCodeUtils.genQrCode(contents, bops, imageIn)) {
                response.setContentType("multipart/form-data");
                response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
                response.getOutputStream().write(bops.toByteArray());
            }
        }
        finally {
            if (bops != null) {
                try {
                    bops.close();
                }
                catch (Exception exception) {}
                bops = null;
            }
        }
    }

    public static boolean genQrCode(String contents, OutputStream out) {
        return QRCodeUtils.genQrCode(contents, 800, 800, DEF_FORMAT, DEF_HINTS, out, -16777216, -1, null);
    }

    public static boolean genQrCode(String contents, OutputStream out, int frontColor, int backgroundColor) {
        return QRCodeUtils.genQrCode(contents, 800, 800, DEF_FORMAT, DEF_HINTS, out, frontColor, backgroundColor, null);
    }

    public static boolean genQrCode(String contents, OutputStream out, InputStream imageIn) throws IOException {
        return QRCodeUtils.genQrCode(contents, 800, 800, DEF_FORMAT, DEF_HINTS, out, -16777201, -1, imageIn);
    }

    public static boolean genQrCode(String contents, int width, int height, String format, Map<EncodeHintType, Object> hints, OutputStream out, int frontColor, int backgroundColor, InputStream imageIn) {
        BitMatrix matrix = null;
        try {
            matrix = factory.encode(contents, BarcodeFormat.QR_CODE, width, height, hints);
            BufferedImage image = QRCodeUtils.toBufferedImage(matrix, frontColor, backgroundColor, imageIn != null);
            if (imageIn != null) {
                BufferedImage embeddedImage = ImageIO.read(imageIn);
                QRCodeUtils.overlapImage(image, embeddedImage);
            }
            QRCodeUtils.writeToStream(image, format, out);
            return true;
        }
        catch (WriterException e) {
            logger.error("QR encode fail! contents[{}], e:{}", (Object)contents, (Object)e);
            return false;
        }
        catch (IOException e) {
            logger.error("QR writeToStream fail! contents[{}], format[{}], e:{}", new Object[]{contents, format, e});
            return false;
        }
        catch (Exception e) {
            logger.error("genQrCode fail! contents[{}], format[{}], e:{}", new Object[]{contents, format, e});
            return false;
        }
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix, int frontColor, int backgroundColor, boolean isEmbedded) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int imageType = QRCodeUtils.getBufferedImageColorModel(frontColor, backgroundColor, isEmbedded);
        BufferedImage image = new BufferedImage(width, height, imageType);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                image.setRGB(x, y, matrix.get(x, y) ? frontColor : backgroundColor);
                ++y;
            }
            ++x;
        }
        return image;
    }

    private static int getBufferedImageColorModel(int frontColor, int backgroundColor, boolean isEmbedded) {
        return !isEmbedded && frontColor == -16777216 && backgroundColor == -1 ? 12 : 1;
    }

    private static void writeToStream(BufferedImage image, String format, OutputStream stream) throws IOException {
        if (!ImageIO.write((RenderedImage)image, format, stream)) {
            throw new IOException("Could not write an image of format " + format);
        }
    }

    private static void overlapImage(BufferedImage image, BufferedImage embeddedImage) {
        try {
            Graphics2D g = image.createGraphics();
            int width = image.getWidth() / 5;
            int height = image.getHeight() / 5;
            int x = (image.getWidth() - width) / 2;
            int y = (image.getHeight() - height) / 2;
            g.drawImage(embeddedImage, x, y, width, height, null);
            g.dispose();
        }
        catch (Exception e) {
            logger.error("overlapImage fail!", (Throwable)e);
        }
    }

    public static String decode(InputStream is) throws IOException, ReaderException {
        BufferedImage image = ImageIO.read(is);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, DEF_CHARSET);
        Result result = new MultiFormatReader().decode(bitmap, hints);
        return result.getText();
    }

    public static void main(String[] args) throws Exception {
        String filePath = "/tmp/qrtest.png";
        String contents = "http://lasedu.genshuixue.com/";
        String logoPath = "/tmp/logo.jpg";
        FileInputStream logo = new FileInputStream(logoPath);
        System.out.println("[" + contents + "]");
        System.out.println(QRCodeUtils.genQrCode(contents, new FileOutputStream(filePath), logo));
        System.out.println("[" + QRCodeUtils.decode(new FileInputStream(filePath)) + "]");
    }
}

