/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.cache.redis;

import com.baijia.commons.lang.utils.BaseUtils;
import com.baijia.commons.lang.utils.DoubleCheckSingleton;
import com.baijia.commons.lang.utils.ServiceLocator;
import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    public static final long OK_RESULT = 1L;
    public static final long NOT_OK_RESULT = 0L;
    public static final int DEF_RETYR_TIMES = 10;
    public static final long DEF_WAIT_TIME = 100L;
    private static RedisUtil ins;
    private JedisPool jedisPool;
    private int retryTimes = 10;
    private long waitTime = 100L;
    private static final int batch_size = 1000;

    public RedisUtil(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public RedisUtil(JedisPool jedisPool, int retryTimes, long waitTime) {
        this.jedisPool = jedisPool;
        this.retryTimes = retryTimes;
        this.waitTime = waitTime;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public static RedisUtil getIns() {
        BaseUtils.setSingleton(new DoubleCheckSingleton<RedisUtil>(){

            @Override
            public RedisUtil create() {
                return new RedisUtil(ServiceLocator.getBean(JedisPool.class), 10, 100L);
            }

            @Override
            public RedisUtil getSingleton() {
                return ins;
            }

            @Override
            public void setSingleton(RedisUtil t) {
                ins = t;
            }
        }, RedisUtil.class);
        return ins;
    }

    public <T> T doRedisAction(RedisAction<T> action) throws Exception {
        return this.doRedisAction(action, this.retryTimes, this.waitTime);
    }

    public <T> T doRedisAction(RedisAction<T> action, int retryTimes, long waitTime) throws Exception {
        int retryCount = 0;
        Jedis jedis = null;
        while (true) {
            try {
                jedis = this.jedisPool.getResource();
                T t = action.doAction(jedis);
                return t;
            }
            catch (JedisConnectionException e) {
                if (retryCount++ >= retryTimes) {
                    throw e;
                }
                log.error("conn error happened when do redis action[" + action.getName() + "]! retry " + retryCount + " times!", (Throwable)e);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            finally {
                if (jedis == null) continue;
                jedis.close();
                continue;
            }
            break;
        }
    }

    public Long setnx(String key, String value) throws Exception {
        return this.setnx(key, value, "setnx");
    }

    public Long setnx(final String key, final String value, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                return jedis.setnx(key, value);
            }
        });
    }

    public Long setnx(String key, String value, long expireTime) throws Exception {
        return this.setnx(key, value, expireTime, "setnx");
    }

    public Long setnx(final String key, final String value, final long expireTime, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                if ("OK".equalsIgnoreCase(jedis.set(key, value, "NX", "EX", expireTime))) {
                    return 1L;
                }
                return 0L;
            }
        });
    }

    public Long expire(String key, int value) throws Exception {
        return this.expire(key, value, "expire");
    }

    public Long expire(final String key, final int value, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                return jedis.expire(key, value);
            }
        });
    }

    public String get(String key) throws Exception {
        return this.get(key, "get");
    }

    public String get(final String key, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<String>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String doAction(Jedis jedis) {
                return jedis.get(key);
            }
        });
    }

    public String set(String key, String value) throws Exception {
        return this.set(key, value, "set");
    }

    public String set(final String key, final String value, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<String>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String doAction(Jedis jedis) {
                return jedis.set(key, value);
            }
        });
    }

    public Long del(String key) throws Exception {
        return this.del(key, "del");
    }

    public Long del(final String key, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                return jedis.del(key);
            }
        });
    }

    public Boolean exists(String key) throws Exception {
        return this.exists(key, "exists");
    }

    public Boolean exists(final String key, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Boolean>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Boolean doAction(Jedis jedis) {
                return jedis.exists(key);
            }
        });
    }

    public void saddLongSet(String key, Collection<Long> sets) throws Exception {
        this.saddLongSet(key, "saddLongSet", sets);
    }

    public void saddLongSet(final String key, final String name, final Collection<Long> sets) throws Exception {
        this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                int size = sets.size();
                size = 1000 > size ? size : 1000;
                byte[][] temp = new byte[size][];
                int i = 0;
                for (List set : CollectionUtils.split(sets, size)) {
                    i = 0;
                    if (set.size() != size) {
                        size = set.size();
                        temp = new byte[size][];
                    }
                    for (Long num : set) {
                        temp[i] = Longs.toByteArray((long)num);
                        ++i;
                    }
                    jedis.sadd(key.getBytes(), (byte[][])temp);
                }
                return 1L;
            }
        });
    }

    public Long sadd(String key, long val) throws Exception {
        return this.sadd(key, val, "sadd");
    }

    public Long sadd(final String key, final long val, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                return jedis.sadd(key.getBytes(), (byte[][])new byte[][]{Longs.toByteArray((long)val)});
            }
        });
    }

    public void saddStrSet(String key, Collection<String> set) throws Exception {
        this.saddStrSet(key, "saddStrSet", set);
    }

    public void saddStrSet(final String key, final String name, final Collection<String> sets) throws Exception {
        this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                int size = sets.size();
                size = 1000 > size ? size : 1000;
                String[] temp = new String[size];
                int i = 0;
                for (List set : CollectionUtils.split(sets, size)) {
                    i = 0;
                    if (set.size() != size) {
                        size = set.size();
                        temp = new String[size];
                    }
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String s;
                        temp[i] = s = (String)iterator.next();
                        ++i;
                    }
                    jedis.sadd(key, temp);
                }
                return 1L;
            }
        });
    }

    public Long sadd(String key, String val) throws Exception {
        return this.sadd(key, val, "sadd");
    }

    public Long sadd(final String key, final String val, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                return jedis.sadd(key, new String[]{val});
            }
        });
    }

    public Set<String> smembers(String key) throws Exception {
        return this.smembers(key, "smembers");
    }

    public Set<String> smembers(final String key, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Set<String>>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<String> doAction(Jedis jedis) {
                return jedis.smembers(key);
            }
        });
    }

    public Long scard(String key) throws Exception {
        return this.scard(key, "scard");
    }

    public Long scard(final String key, final String name) throws Exception {
        return this.doRedisAction(new RedisAction<Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Long doAction(Jedis jedis) {
                return jedis.scard(key);
            }
        });
    }

    public <K, V> Map<K, V> pipeline(final Collection<K> keys, final PipelineAction<K, V> action) throws Exception {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)this.doRedisAction(new RedisAction<Map<K, V>>(){

            @Override
            public String getName() {
                return action.getName();
            }

            @Override
            public Map<K, V> doAction(Jedis jedis) {
                int size = keys.size();
                HashMap<Object, Object> result = new HashMap<Object, Object>(size);
                size = 1000 > size ? size : 1000;
                HashMap responses = new HashMap(size);
                for (List list : CollectionUtils.split(keys, size)) {
                    Pipeline p = jedis.pipelined();
                    for (Object key : list) {
                        responses.put(key, action.doAction(p, key));
                    }
                    p.sync();
                    for (Object k : responses.keySet()) {
                        result.put(k, ((Response)responses.get(k)).get());
                    }
                    responses.clear();
                }
                return result;
            }
        });
    }

    public Map<String, Long> scard(Collection<String> keys) throws Exception {
        return this.scard(keys, "scard by pipeline");
    }

    public Map<String, Long> scard(Collection<String> keys, final String name) throws Exception {
        return this.pipeline(keys, new PipelineAction<String, Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Response<Long> doAction(Pipeline p, String key) {
                return p.scard(key);
            }
        });
    }

    public Map<String, Set<String>> smembers(Collection<String> keys) throws Exception {
        return this.smembers(keys, "smembers by pipeline");
    }

    public Map<String, Set<String>> smembers(Collection<String> keys, final String name) throws Exception {
        return this.pipeline(keys, new PipelineAction<String, Set<String>>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Response<Set<String>> doAction(Pipeline p, String key) {
                return p.smembers(key);
            }
        });
    }

    public Map<String, Long> del(Collection<String> keys) throws Exception {
        return this.del(keys, "del by pipeline");
    }

    public Map<String, Long> del(Collection<String> keys, final String name) throws Exception {
        return this.pipeline(keys, new PipelineAction<String, Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Response<Long> doAction(Pipeline p, String key) {
                return p.del(key);
            }
        });
    }

    public Map<String, Long> expire(Collection<String> keys, int value) throws Exception {
        return this.expire(keys, value, "expire by pipeline");
    }

    public Map<String, Long> expire(Collection<String> keys, final int value, final String name) throws Exception {
        return this.pipeline(keys, new PipelineAction<String, Long>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Response<Long> doAction(Pipeline p, String key) {
                return p.expire(key, value);
            }
        });
    }

    public void saddLong(Map<String, ? extends Collection<Long>> map) throws Exception {
        this.saddLong(map, "saddLong by pipeline");
    }

    public void saddLong(final Map<String, ? extends Collection<Long>> map, final String name) throws Exception {
        if (map == null || map.isEmpty()) {
            return;
        }
        this.doRedisAction(new RedisAction<Void>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Void doAction(Jedis jedis) {
                Pipeline p = null;
                int count = 0;
                for (String key : map.keySet()) {
                    Collection sets = (Collection)map.get(key);
                    int size = sets.size();
                    if (size <= 0) continue;
                    size = 1000 > size ? size : 1000;
                    byte[][] temp = new byte[size][];
                    for (List set : CollectionUtils.split(sets, size)) {
                        if (count == 0) {
                            p = jedis.pipelined();
                        }
                        int i = 0;
                        if (set.size() != size) {
                            size = set.size();
                            temp = new byte[size][];
                        }
                        for (Long num : set) {
                            temp[i] = Longs.toByteArray((long)num);
                            ++i;
                        }
                        p.sadd(key.getBytes(), (byte[][])temp);
                        if (++count < 1000) continue;
                        p.sync();
                        count = 0;
                    }
                }
                if (count > 0) {
                    p.sync();
                }
                return null;
            }
        });
    }

    public void saddStr(Map<String, ? extends Collection<String>> map) throws Exception {
        this.saddStr(map, "saddLong by pipeline");
    }

    public void saddStr(final Map<String, ? extends Collection<String>> map, final String name) throws Exception {
        if (map == null || map.isEmpty()) {
            return;
        }
        this.doRedisAction(new RedisAction<Void>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Void doAction(Jedis jedis) {
                Pipeline p = null;
                int count = 0;
                for (String key : map.keySet()) {
                    Collection sets = (Collection)map.get(key);
                    int size = sets.size();
                    if (size <= 0) continue;
                    size = 1000 > size ? size : 1000;
                    String[] temp = new String[size];
                    for (List set : CollectionUtils.split(sets, size)) {
                        if (count == 0) {
                            p = jedis.pipelined();
                        }
                        int i = 0;
                        if (set.size() != size) {
                            size = set.size();
                            temp = new String[size];
                        }
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            String s;
                            temp[i] = s = (String)iterator.next();
                            ++i;
                        }
                        p.sadd(key, temp);
                        if (++count < 1000) continue;
                        p.sync();
                        count = 0;
                    }
                }
                if (count > 0) {
                    p.sync();
                }
                return null;
            }
        });
    }

    public void destroy() {
        this.jedisPool.destroy();
    }

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("classpath:ctx-redis.xml");
        ServiceLocator locator = new ServiceLocator();
        locator.setApplicationContext((ApplicationContext)context);
        RedisUtil redisUtil = RedisUtil.getIns();
        RedisUtil.testRetry(redisUtil);
        RedisUtil.testSetExpireExpire(redisUtil);
        RedisUtil.testSetExpireSet(redisUtil);
    }

    private static void testRetry(RedisUtil redisUtil) throws Exception {
        System.out.println("==============================================");
        log.info("test retry");
        String key = "ljx-20150909-test-key";
        redisUtil.doRedisAction(new RedisAction<String>(){

            @Override
            public String getName() {
                return "retry get";
            }

            @Override
            public String doAction(Jedis jedis) {
                return jedis.get("ljx-20150909-test-key");
            }
        }, 3, 200L);
    }

    private static void testSetExpireExpire(RedisUtil redisUtil) throws Exception {
        String key = "ljx-20150909-test-key";
        String value = "ljx-20150909-test-value";
        int expireTime = 2;
        System.out.println("==============================================");
        log.info("test set expire expire");
        redisUtil.setnx("ljx-20150909-test-key", "ljx-20150909-test-value");
        redisUtil.expire("ljx-20150909-test-key", 2);
        long start = System.currentTimeMillis();
        Thread.sleep(1000L);
        log.info("is expire:" + (redisUtil.get("ljx-20150909-test-key") == null));
        redisUtil.expire("ljx-20150909-test-key", 2);
        while (redisUtil.get("ljx-20150909-test-key") != null) {
            Thread.sleep(100L);
        }
        long end = System.currentTimeMillis();
        log.info("expire after:" + (end - start));
    }

    private static void testSetExpireSet(RedisUtil redisUtil) throws Exception {
        String key = "ljx-20150909-test-key";
        String value = "ljx-20150909-test-value";
        int expireTime = 2;
        System.out.println("==============================================");
        log.info("test set expire set");
        redisUtil.setnx("ljx-20150909-test-key", "ljx-20150909-test-value");
        redisUtil.expire("ljx-20150909-test-key", 2);
        long start = System.currentTimeMillis();
        Thread.sleep(1000L);
        log.info("is expire:" + (redisUtil.get("ljx-20150909-test-key") == null));
        redisUtil.set("ljx-20150909-test-key", "ljx-20150909-test-value");
        int count = 0;
        while (redisUtil.get("ljx-20150909-test-key") != null && count++ < 100) {
            Thread.sleep(100L);
        }
        long end = System.currentTimeMillis();
        if (redisUtil.get("ljx-20150909-test-key") != null) {
            redisUtil.del("ljx-20150909-test-key");
            log.info("unexpire,del it!");
        } else {
            log.info("expire after:" + (end - start));
        }
    }

    public static interface PipelineAction<K, V> {
        public String getName();

        public Response<V> doAction(Pipeline var1, K var2);
    }

    public static interface RedisAction<T> {
        public String getName();

        public T doAction(Jedis var1);
    }
}

