/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.cache.redis;

import com.baijia.commons.lang.utils.cache.redis.LockObj;
import com.baijia.commons.lang.utils.cache.redis.RedisBaseLock;
import com.baijia.commons.lang.utils.cache.redis.RedisUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLock
extends RedisBaseLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);

    public RedisLock(RedisUtil redisUtil, String key) {
        this(redisUtil, key, key);
    }

    public RedisLock(RedisUtil redisUtil, String key, String owner) {
        this(redisUtil, key, owner, 60L);
    }

    public RedisLock(RedisUtil redisUtil, String key, String owner, long expireTimeInSeconds) {
        super(redisUtil, key, owner, expireTimeInSeconds);
    }

    public RedisLock(RedisUtil redisUtil, String key, String owner, long expireTime, TimeUnit expireTimeUnit) {
        super(redisUtil, key, owner, expireTime, expireTimeUnit);
    }

    @Override
    public Boolean unlock(final String key, final LockObj value, final boolean force) throws Exception {
        boolean succ = this.synAct(new RedisBaseLock.RedisLockAction<Boolean>(){

            @Override
            public Boolean doAction(RedisUtil redisUtil) throws Exception {
                if (!redisUtil.exists(key).booleanValue()) {
                    return true;
                }
                LockObj last = RedisLock.this.decodeLock(redisUtil.get(key));
                if (force || last == null || last.equals(value)) {
                    redisUtil.del(key);
                    if (log.isDebugEnabled()) {
                        log.debug("unlock, key[{}], value[{}], last[{}]", new Object[]{key, value, last});
                    }
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("unlock fail, key[{}], value[{}], last[{}]", new Object[]{key, value, last});
                }
                return false;
            }
        }, false);
        if (succ && this.value != null) {
            this.value = null;
        }
        return succ;
    }
}

