/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.cache.redis;

import com.baijia.commons.lang.utils.cache.redis.LockObj;
import com.baijia.commons.lang.utils.cache.redis.RedisUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedisBaseLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(RedisBaseLock.class);
    protected static final ConcurrentHashMap<String, LockObj> LOCK_MAP = new ConcurrentHashMap();
    private static final String SYN_PREFIX = "syn_";
    private static final int SYN_EXPIRE = 5;
    protected static final long DEF_LOCK_EXPIRE_TIME_IN_SECONDS = 60L;
    protected static final long DEF_WAIT_TIME_IN_MILLISECONDS = 100L;
    protected RedisUtil redisUtil;
    protected String key;
    protected String owner;
    protected long expireTime;
    protected TimeUnit expireTimeUnit;
    private String synKey;
    protected LockObj value;
    protected static final Gson gson = new Gson();
    protected static final Type LOCK_OBJ_TYPE = new TypeToken<LockObj>(){}.getType();

    protected RedisBaseLock(RedisUtil redisUtil, String key, String owner) {
        this(redisUtil, key, owner, 60L);
    }

    protected RedisBaseLock(RedisUtil redisUtil, String key, String owner, long expireTimeInSeconds) {
        this.redisUtil = redisUtil;
        this.key = key;
        this.owner = owner;
        this.expireTime = expireTimeInSeconds;
        this.expireTimeUnit = TimeUnit.SECONDS;
        this.synKey = SYN_PREFIX + key;
    }

    protected RedisBaseLock(RedisUtil redisUtil, String key, String owner, long expireTime, TimeUnit expireTimeUnit) {
        this.redisUtil = redisUtil;
        this.key = key;
        this.owner = owner;
        this.expireTime = expireTime;
        this.expireTimeUnit = expireTimeUnit;
        this.synKey = SYN_PREFIX + key;
    }

    protected <T> T synAct(RedisLockAction<T> action, T def) throws Exception {
        boolean syn = false;
        try {
            boolean bl = syn = this.redisUtil.setnx(this.synKey, this.owner, 5L) == 1L;
            if (syn) {
                T t = action.doAction(this.redisUtil);
                return t;
            }
            T t = def;
            return t;
        }
        finally {
            if (syn) {
                this.redisUtil.del(this.synKey);
            }
        }
    }

    @Override
    public void lock() {
        this.tryLock(-1L, null);
    }

    @Override
    @Deprecated
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5!");
    }

    @Override
    public boolean tryLock() {
        return this.tryLock(0L, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLock(long timeout, TimeUnit unit) {
        long start = System.nanoTime();
        try {
            do {
                if (this.lock(this.key)) {
                    if (!log.isDebugEnabled()) return true;
                    log.debug("get lock, key[{}], owner[{}], expire[{}]", new Object[]{this.key, this.owner, this.expireTime});
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("key[{}] is locked by owner[{}]", (Object)this.key, (Object)this.redisUtil.get(this.key));
                }
                if (timeout == 0L) {
                    return false;
                }
                Thread.sleep(100L);
            } while (timeout < 0L || System.nanoTime() - start < unit.toNanos(timeout));
            return false;
        }
        catch (Exception e) {
            log.error("lock key[" + this.key + "] error!", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean lock(String key) throws Exception {
        boolean succ = false;
        LockObj obj = this.createLockObj();
        LockObj last = LOCK_MAP.putIfAbsent(key, obj);
        if (last != null) {
            if (last.getExpireTime() <= 0L) {
                log.warn("lock without expire time : {}", (Object)last);
                return false;
            }
            if (System.nanoTime() - last.getLockTime() < last.getExpireTime()) {
                return false;
            }
            LOCK_MAP.remove(key, last);
            last = LOCK_MAP.putIfAbsent(key, obj);
            if (last != null) {
                return false;
            }
            succ = this.redisUtil.setnx(key, this.encodeLock(obj), this.expireTimeUnit.toSeconds(this.expireTime)) == 1L;
        } else {
            try {
                succ = this.expireTime > 0L ? this.redisUtil.setnx(key, this.encodeLock(obj), this.expireTimeUnit.toSeconds(this.expireTime)) == 1L : this.redisUtil.setnx(key, this.encodeLock(obj)) == 1L;
            }
            catch (Exception e) {
                LOCK_MAP.remove(key, obj);
                throw e;
            }
        }
        if (succ) {
            this.value = obj;
            return succ;
        }
        LOCK_MAP.remove(key, obj);
        return succ;
    }

    protected LockObj createLockObj() {
        LockObj obj = new LockObj();
        obj.setOwner(this.owner);
        obj.setExpireTime(this.expireTimeUnit.toNanos(this.expireTime));
        obj.setLockTime(System.nanoTime());
        return obj;
    }

    @Override
    public void unlock() {
        try {
            this.unlock(true);
        }
        catch (Exception e) {
            log.error("release lock key[" + this.key + "] error!", (Throwable)e);
        }
    }

    public void unlock(boolean force) {
        block8: {
            try {
                try {
                    this.unlock(this.key, this.value, force);
                }
                catch (Exception e) {
                    log.error("release lock key[" + this.key + "] error!", (Throwable)e);
                    if (force) {
                        LockObj obj = LOCK_MAP.get(this.key);
                        LOCK_MAP.remove(this.key, obj);
                        break block8;
                    }
                    LOCK_MAP.remove(this.key, this.value);
                }
            }
            finally {
                if (force) {
                    LockObj obj = LOCK_MAP.get(this.key);
                    LOCK_MAP.remove(this.key, obj);
                } else {
                    LOCK_MAP.remove(this.key, this.value);
                }
            }
        }
    }

    public abstract Boolean unlock(String var1, LockObj var2, boolean var3) throws Exception;

    @Override
    @Deprecated
    public Condition newCondition() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5!");
    }

    protected LockObj decodeLock(String json) {
        return (LockObj)gson.fromJson(json, LOCK_OBJ_TYPE);
    }

    protected String encodeLock(LockObj obj) {
        return gson.toJson((Object)obj);
    }

    protected static interface RedisLockAction<T> {
        public T doAction(RedisUtil var1) throws Exception;
    }
}

