/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.cache.redis;

import com.baijia.commons.lang.utils.cache.redis.Heartbeat;
import com.baijia.commons.lang.utils.cache.redis.HeartbeatBaseInfo;
import com.baijia.commons.lang.utils.cache.redis.LockObj;
import com.baijia.commons.lang.utils.cache.redis.RedisBaseLock;
import com.baijia.commons.lang.utils.cache.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatLock
extends RedisBaseLock {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatLock.class);
    private Heartbeat heartbeat;

    public HeartbeatLock(RedisUtil redisUtil, String key) {
        this(redisUtil, key, Heartbeat.getMyHeartbeat());
    }

    public HeartbeatLock(RedisUtil redisUtil, String key, Heartbeat heartbeat) {
        super(redisUtil, key, heartbeat.getProcName(), 0L);
        this.heartbeat = heartbeat;
    }

    public Heartbeat getHeartbeat() {
        return this.heartbeat;
    }

    @Override
    protected boolean lock(String key) throws Exception {
        boolean succ = super.lock(key);
        if (succ) {
            return succ;
        }
        if (this.unlock(key, this.value, false).booleanValue()) {
            succ = super.lock(key);
        }
        return succ;
    }

    @Override
    protected LockObj createLockObj() {
        LockObj obj = super.createLockObj();
        obj.setHeartbeatStartAt(this.heartbeat.getHeartbeatInfo().getStartAt());
        return obj;
    }

    @Override
    public Boolean unlock(final String key, final LockObj value, final boolean force) throws Exception {
        if (!this.redisUtil.exists(key).booleanValue()) {
            return true;
        }
        if (!this.needUnlock(key, value, force)) {
            return false;
        }
        return this.synAct(new RedisBaseLock.RedisLockAction<Boolean>(){

            @Override
            public Boolean doAction(RedisUtil redisUtil) throws Exception {
                if (!redisUtil.exists(key).booleanValue()) {
                    return true;
                }
                if (HeartbeatLock.this.needUnlock(key, value, force)) {
                    redisUtil.del(key);
                    if (log.isDebugEnabled()) {
                        log.debug("unlock, key[{}]", (Object)key);
                    }
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("unlock fail, key[{}]", (Object)key);
                }
                return false;
            }
        }, false);
    }

    private boolean needUnlock(String key, LockObj value, boolean force) throws Exception {
        if (force) {
            return true;
        }
        LockObj last = this.decodeLock(this.redisUtil.get(key));
        if (last == null || last.equals(value) || last.getOwner().equals(this.heartbeat.getHeartbeatInfo().getProcName()) && (!LOCK_MAP.containsKey(key) || last.getHeartbeatStartAt() != this.heartbeat.getHeartbeatInfo().getStartAt())) {
            return true;
        }
        HeartbeatBaseInfo ownerHeartbeat = Heartbeat.readHeartbeatInfo(last.getOwner(), this.redisUtil);
        return ownerHeartbeat == null || !ownerHeartbeat.isValid();
    }
}

