/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.cache.redis;

import com.baijia.commons.lang.utils.BaseUtils;
import com.baijia.commons.lang.utils.DoubleCheckSingleton;
import com.baijia.commons.lang.utils.ServiceLocator;
import com.baijia.commons.lang.utils.cache.redis.HeartbeatBaseInfo;
import com.baijia.commons.lang.utils.cache.redis.RedisUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heartbeat
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(Heartbeat.class);
    private static Heartbeat myHeartbeat;
    public static int DEF_EXPIRE_TIME;
    private RedisUtil redisUtil;
    private String procName;
    private long interval = 10000L;
    private long startAt = System.currentTimeMillis();
    private int expireTime = DEF_EXPIRE_TIME;
    private HeartbeatBaseInfo heartbeatInfo;
    private volatile boolean run = false;

    static {
        DEF_EXPIRE_TIME = 300;
    }

    public Heartbeat() {
        this(RedisUtil.getIns(), DEF_EXPIRE_TIME);
    }

    public Heartbeat(RedisUtil redisUtil, int expireTime) {
        this(Heartbeat.genDefProcName(), redisUtil, expireTime);
    }

    public Heartbeat(String procName, RedisUtil redisUtil, int expireTime) {
        this.redisUtil = redisUtil;
        this.procName = procName;
        this.expireTime = expireTime;
        this.setDaemon(true);
    }

    public String getProcName() {
        return this.procName;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    private static String genDefProcName() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("user.name"));
        try {
            InetAddress ia = InetAddress.getLocalHost();
            sb.append("@").append(ia.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        sb.append(":").append(System.getProperty("user.dir"));
        return sb.toString();
    }

    public void destroy() {
        if (this.run) {
            this.run = false;
        }
    }

    protected HeartbeatBaseInfo genHeartbeatInfo() {
        return new HeartbeatBaseInfo();
    }

    @Override
    public void run() {
        this.run = true;
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException interruptedException) {}
        while (this.run) {
            try {
                this.beat();
                Thread.sleep(this.interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init() {
        this.heartbeatInfo = this.readHeartbeatInfo();
        if (this.heartbeatInfo == null) {
            this.heartbeatInfo = this.genHeartbeatInfo();
        } else {
            long lastBeatTime = this.heartbeatInfo.getLastBeatTime();
            try {
                Thread.sleep(this.heartbeatInfo.getInterval() + 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.heartbeatInfo = this.readHeartbeatInfo();
            if (this.heartbeatInfo != null && this.heartbeatInfo.getLastBeatTime() != lastBeatTime) {
                log.error("another proc[{}] is running, exiting...", (Object)this.getProcName());
                System.exit(1);
            }
        }
        this.heartbeatInfo.setProcName(this.getProcName());
        this.heartbeatInfo.setStartAt(this.startAt);
        this.heartbeatInfo.setInterval(this.interval);
        this.heartbeatInfo.setCount(0L);
        try {
            this.beat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.start();
    }

    private void beat() throws Exception {
        this.heartbeatInfo.setCount(this.heartbeatInfo.getCount() + 1L);
        this.heartbeatInfo.setLastBeatTime(System.currentTimeMillis());
        Heartbeat.writeHeartbeatInfo(this.heartbeatInfo, this.expireTime, this.redisUtil);
    }

    public HeartbeatBaseInfo getHeartbeatInfo() {
        return this.heartbeatInfo;
    }

    public HeartbeatBaseInfo readHeartbeatInfo() {
        return Heartbeat.readHeartbeatInfo(this.getProcName(), this.redisUtil);
    }

    public static HeartbeatBaseInfo readHeartbeatInfo(String procName, RedisUtil redisUtil) {
        String json = null;
        try {
            json = redisUtil.get(procName);
        }
        catch (Exception e) {
            log.error("read heartbeat error!", (Throwable)e);
        }
        return HeartbeatBaseInfo.fromJson(json);
    }

    protected static void writeHeartbeatInfo(HeartbeatBaseInfo obj, int expireTime, RedisUtil redisUtil) throws Exception {
        redisUtil.set(obj.getProcName(), obj.toJson());
        redisUtil.expire(obj.getProcName(), expireTime);
    }

    public static Heartbeat getMyHeartbeat() {
        BaseUtils.setSingleton(new DoubleCheckSingleton<Heartbeat>(){

            @Override
            public Heartbeat create() {
                Heartbeat heartbeat = null;
                try {
                    heartbeat = ServiceLocator.getBean(Heartbeat.class);
                }
                catch (Exception e) {
                    log.info("undefine heartbeat! new a default one!", (Throwable)e);
                    heartbeat = new Heartbeat(RedisUtil.getIns(), DEF_EXPIRE_TIME);
                }
                heartbeat.init();
                return heartbeat;
            }

            @Override
            public Heartbeat getSingleton() {
                return myHeartbeat;
            }

            @Override
            public void setSingleton(Heartbeat t) {
                myHeartbeat = t;
            }
        }, Heartbeat.class);
        return myHeartbeat;
    }
}

