/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.bean;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class BeanUtils {
    private static Converter<String, String> UPPER_CAMEL_2_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private static Converter<String, String> LOWER_CAMEL_2_UPPER_CAMEL = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private static Converter<String, String> LOWER_CAMEL_2_LOWER_UNDERSCORE = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
    private static Converter<String, String> LOWER_UNDERSCORE_2_LOWER_CAMEL = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);

    @Deprecated
    public static <T> T mapToBean(Map<String, Object> map, T obj) throws Exception {
        if (map == null || map.size() <= 0 || obj == null) {
            return obj;
        }
        boolean ret = true;
        Class<?> oo = obj.getClass();
        ArrayList clazzs = new ArrayList();
        while (ret) {
            clazzs.add(oo);
            if ((oo = oo.getSuperclass()) != null && oo != Object.class) continue;
        }
        for (int i = 0; i < clazzs.size(); ++i) {
            Field[] fields;
            for (Field field : fields = ((Class)clazzs.get(i)).getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || field == null) continue;
                field.setAccessible(true);
                field.set(obj, map.get(field.getName()));
            }
        }
        return obj;
    }

    @Deprecated
    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) throws Exception {
        if (beanClass == null) {
            return null;
        }
        return BeanUtils.mapToBean(map, beanClass.newInstance());
    }

    public static Map<String, Object> objectToMap(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        boolean ret = true;
        Class<?> oo = obj.getClass();
        ArrayList clazzs = new ArrayList();
        while (ret) {
            clazzs.add(oo);
            if ((oo = oo.getSuperclass()) != null && oo != Object.class) continue;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < clazzs.size(); ++i) {
            Field[] declaredFields;
            for (Field field : declaredFields = ((Class)clazzs.get(i)).getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                field.setAccessible(true);
                map.put(field.getName(), field.get(obj));
            }
        }
        return map;
    }

    public static List<Method> getGetterFromBean(Class<?> clazz) {
        return BeanUtils.getGetterFromBean(clazz, true);
    }

    public static List<Method> getGetterFromBean(Class<?> clazz, boolean containSuper) {
        Method[] methods = containSuper ? clazz.getMethods() : clazz.getDeclaredMethods();
        return Arrays.stream(methods).filter(method -> !Modifier.isStatic(method.getModifiers()) && !Modifier.isFinal(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && !method.getName().equals("get")).collect(Collectors.toList());
    }

    public static List<Method> getSetterFromBean(Class<?> clazz) {
        return BeanUtils.getSetterFromBean(clazz, true);
    }

    public static List<Method> getSetterFromBean(Class<?> clazz, boolean containSuper) {
        Method[] methods = containSuper ? clazz.getMethods() : clazz.getDeclaredMethods();
        return Arrays.stream(methods).filter(method -> !Modifier.isStatic(method.getModifiers()) && !Modifier.isFinal(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("set") && !method.getName().equals("set")).collect(Collectors.toList());
    }

    public static String getGetterMethodName(String field) {
        return "get" + (String)LOWER_CAMEL_2_UPPER_CAMEL.convert((Object)field);
    }

    public static String getSetterMethodName(String field) {
        return "set" + (String)LOWER_CAMEL_2_UPPER_CAMEL.convert((Object)field);
    }

    public static Method getMethodFromBeanByMethodName(Class<?> clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Method getGetterFromBeanByField(Class<?> clazz, String field) {
        return BeanUtils.getMethodFromBeanByMethodName(clazz, BeanUtils.getGetterMethodName(field));
    }

    public static Method getSetterFromBeanByField(Class<?> clazz, String field) {
        return BeanUtils.getMethodFromBeanByMethodName(clazz, BeanUtils.getSetterMethodName(field));
    }

    public static List<String> getBeanFieldsFromBean(Class<?> clazz) {
        return BeanUtils.getBeanFieldsFromBean(clazz, true);
    }

    public static List<String> getBeanFieldsFromBean(Class<?> clazz, boolean containSuper) {
        return BeanUtils.getBeanFieldsFromGetter(BeanUtils.getGetterFromBean(clazz, containSuper));
    }

    public static List<String> getBeanFieldsFromGetter(List<Method> getters) {
        if (CollectionUtils.isEmpty(getters)) {
            return Collections.emptyList();
        }
        return Lists.transform(getters, method -> {
            int endIndex = method.getName().length();
            if (BeanUtils.getAllSuperClass(method.getReturnType()).contains(Collection.class) && method.getName().endsWith("s")) {
                --endIndex;
            }
            return (String)UPPER_CAMEL_2_LOWER_CAMEL.convert((Object)method.getName().substring(3, endIndex));
        });
    }

    public static List<String> getTableFieldsFromBeanFields(List<String> beanFields) {
        return BeanUtils.getTableFieldsFromBeanFields(beanFields, Collections.emptyMap());
    }

    public static List<String> getTableFieldsFromBeanFields(List<String> beanFields, Map<String, String> extMap) {
        if (CollectionUtils.isEmpty(beanFields)) {
            return Collections.emptyList();
        }
        Map transformMap = (Map)MoreObjects.firstNonNull(extMap, Collections.emptyMap());
        return Lists.transform(beanFields, lowerCamelName -> {
            String lowerUnderscoreName = (String)transformMap.get(lowerCamelName);
            if (lowerUnderscoreName == null) {
                lowerUnderscoreName = (String)LOWER_CAMEL_2_LOWER_UNDERSCORE.convert(lowerCamelName);
            }
            return lowerUnderscoreName;
        });
    }

    public static List<String> getTableFieldsFromBean(Class<?> clazz) {
        return BeanUtils.getTableFieldsFromBean(clazz, Collections.emptyMap(), true);
    }

    public static List<String> getTableFieldsFromBean(Class<?> clazz, Map<String, String> extMap, boolean containSuper) {
        return BeanUtils.getTableFieldsFromBeanFields(BeanUtils.getBeanFieldsFromBean(clazz, containSuper), extMap);
    }

    public static List<Class<?>> getAllSuperClass(Class<?> clazz) {
        ArrayList clazzs = new ArrayList();
        for (Class<?> oo = clazz; oo != null && oo != Object.class; oo = oo.getSuperclass()) {
            clazzs.add(oo);
        }
        return clazzs;
    }

    public static Class<?>[] getActualTypeClass(Class<?> clazz) {
        Type[] types = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        Class[] clazzs = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            clazzs[i] = (Class)types[i];
        }
        return clazzs;
    }

    public static String convertBeanField2TableField(String beanField) {
        return (String)LOWER_CAMEL_2_LOWER_UNDERSCORE.convert((Object)beanField);
    }

    public static String convertTableField2BeanField(String tableField) {
        return (String)LOWER_UNDERSCORE_2_LOWER_CAMEL.convert((Object)tableField);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(BeanUtils.getTableFieldsFromBean(TestObj.class, null, true));
    }

    private static class TestSuperObj {
        private String sS;
        private String superField;

        public String getSS() {
            return this.sS;
        }

        public String getSuperField() {
            return this.superField;
        }

        public void setSS(String sS) {
            this.sS = sS;
        }

        public void setSuperField(String superField) {
            this.superField = superField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestSuperObj)) {
                return false;
            }
            TestSuperObj other = (TestSuperObj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sS = this.getSS();
            String other$sS = other.getSS();
            if (this$sS == null ? other$sS != null : !this$sS.equals(other$sS)) {
                return false;
            }
            String this$superField = this.getSuperField();
            String other$superField = other.getSuperField();
            return !(this$superField == null ? other$superField != null : !this$superField.equals(other$superField));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TestSuperObj;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sS = this.getSS();
            result = result * 59 + ($sS == null ? 43 : $sS.hashCode());
            String $superField = this.getSuperField();
            result = result * 59 + ($superField == null ? 43 : $superField.hashCode());
            return result;
        }

        public String toString() {
            return "BeanUtils.TestSuperObj(sS=" + this.getSS() + ", superField=" + this.getSuperField() + ")";
        }
    }

    private static class TestObj
    extends TestSuperObj {
        private String sS;
        private Integer iI;
        private Boolean bB;
        private final String finalStr = "";

        public static String getStaticStr() {
            return "";
        }

        public final String getFinalStr() {
            return "";
        }

        @Override
        public String getSS() {
            return this.sS;
        }

        public Integer getII() {
            return this.iI;
        }

        public Boolean getBB() {
            return this.bB;
        }

        @Override
        public void setSS(String sS) {
            this.sS = sS;
        }

        public void setII(Integer iI) {
            this.iI = iI;
        }

        public void setBB(Boolean bB) {
            this.bB = bB;
        }

        @Override
        public String toString() {
            return "BeanUtils.TestObj(sS=" + this.getSS() + ", iI=" + this.getII() + ", bB=" + this.getBB() + ", finalStr=" + this.getFinalStr() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestObj)) {
                return false;
            }
            TestObj other = (TestObj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$sS = this.getSS();
            String other$sS = other.getSS();
            if (this$sS == null ? other$sS != null : !this$sS.equals(other$sS)) {
                return false;
            }
            Integer this$iI = this.getII();
            Integer other$iI = other.getII();
            if (this$iI == null ? other$iI != null : !((Object)this$iI).equals(other$iI)) {
                return false;
            }
            Boolean this$bB = this.getBB();
            Boolean other$bB = other.getBB();
            if (this$bB == null ? other$bB != null : !((Object)this$bB).equals(other$bB)) {
                return false;
            }
            String this$finalStr = this.getFinalStr();
            String other$finalStr = other.getFinalStr();
            return !(this$finalStr == null ? other$finalStr != null : !this$finalStr.equals(other$finalStr));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TestObj;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            String $sS = this.getSS();
            result = result * 59 + ($sS == null ? 43 : $sS.hashCode());
            Integer $iI = this.getII();
            result = result * 59 + ($iI == null ? 43 : ((Object)$iI).hashCode());
            Boolean $bB = this.getBB();
            result = result * 59 + ($bB == null ? 43 : ((Object)$bB).hashCode());
            String $finalStr = this.getFinalStr();
            result = result * 59 + ($finalStr == null ? 43 : $finalStr.hashCode());
            return result;
        }
    }
}

