/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

public class PropertiesReader {
    private static Map<String, Properties> filePropMapping = new WeakHashMap<String, Properties>();

    public static String getValue(String file_name, String key) throws MissingResourceException {
        ResourceBundle res = ResourceBundle.getBundle(file_name);
        String value = res.getString(key);
        return value.trim();
    }

    public static Properties fillProperties(String file_name) throws MissingResourceException {
        if (!file_name.endsWith(".properties")) {
            file_name = String.valueOf(file_name) + ".properties";
        }
        return PropertiesReader.getProperties(file_name);
    }

    public static Properties getProperties(String fileName) {
        return PropertiesReader.getProperties(fileName, PropertiesReader.class.getClassLoader());
    }

    public static Properties getProperties(String fileName, ClassLoader cl) {
        if (filePropMapping.containsKey(fileName)) {
            return filePropMapping.get(fileName);
        }
        Properties properties = new Properties();
        InputStream is = cl.getResourceAsStream(fileName);
        try {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("load properties file error", e);
            }
            filePropMapping.put(fileName, properties);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("load properties file error", e);
            }
        }
        return properties;
    }
}

