/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.JavaType;

public abstract class JacksonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    static {
        mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static final String obj2Str(Object o) throws JsonGenerationException, JsonMappingException, IOException {
        return mapper.writeValueAsString(o);
    }

    public static final String safeObj2Str(Object o) {
        String result = "";
        try {
            result = JacksonUtil.obj2Str(o);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static final void writeObj(OutputStream out, Object value) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(out, value);
    }

    public static final <T> T str2Obj(String s, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(s, valueType);
    }

    public static final <T> List<T> str2List(String s, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{valueType});
        return (List)mapper.readValue(s, javaType);
    }

    public static final <T> T readObj(InputStream in, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(in, valueType);
    }

    public static final <T> T readObj(InputStream in, JavaType valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(in, valueType);
    }
}

