/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils;

import com.baijia.commons.lang.utils.DoubleCheckSingleton;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseUtils {
    public static <K, V> Map<K, V> listToMap(List<V> list, String propertyName) {
        HashMap<V, V> map = new HashMap<V, V>();
        for (V v : list) {
            V key = BaseUtils.getValue(v, propertyName);
            map.put(key, v);
        }
        return map;
    }

    public static <T, V> V getValue(T obj, String propertyName) {
        Object ret = null;
        try {
            Field field = obj.getClass().getDeclaredField(propertyName);
            field.setAccessible(true);
            ret = field.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (V)ret;
    }

    public static <T, V> String getStringArray(List<T> objs, String param) {
        StringBuffer sb = new StringBuffer("(");
        try {
            for (T object : objs) {
                Field field = object.getClass().getDeclaredField(param);
                field.setAccessible(true);
                Object propertyVal = field.get(object);
                sb.append(propertyVal).append(",");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String ret = "";
        if (sb.toString().endsWith(",")) {
            ret = sb.substring(0, sb.length() - 1);
        }
        ret = String.valueOf(ret) + ")";
        return ret;
    }

    public static <T, V> List<V> getPropertyCollections(List<T> objs, String propertyName) {
        ArrayList<Object> arr = new ArrayList<Object>();
        try {
            for (T object : objs) {
                Field field = object.getClass().getDeclaredField(propertyName);
                field.setAccessible(true);
                Object propertyVal = field.get(object);
                arr.add(propertyVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void setSingleton(DoubleCheckSingleton<T> creator, Class<?> clazz) {
        T singleton = creator.getSingleton();
        if (singleton == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                singleton = creator.getSingleton();
                if (singleton == null) {
                    try {
                        singleton = creator.create();
                    }
                    finally {
                        creator.setSingleton(singleton);
                    }
                }
            }
        }
    }
}

