/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.utils;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class PasswordUtil {
    private static final String PREFIX = "sha256";
    private static final String SPLIT = "$";
    private static final int SALT_BYTE_SIZE = 24;
    private static final int ITERATION_INDEX = 1;
    private static final int SALT_INDEX = 2;
    private static final int PBKDF2_INDEX = 3;
    private static final String DEF_ALGORITHM = "HmacSHA256";
    private static final int DEF_ITERATIONS = 12000;
    private static final int DEF_PWD_LEN = 64;
    private static final char[] SALT_POOL = new char[]{'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', 'z', 'x', 'c', 'v', 'b', 'n', 'm', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '7', '8', '9', '4', '5', '6', '1', '2', '3', '0'};
    public static final char[] PWD_LETTER_POOL = new char[]{'z', 'x', 'c', 'v', 'b', 'n', 'm', 'a', 's', 'd', 'f', 'h', 'j', 'k', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'p'};
    public static final char[] PWD_NUMBER_POOL = new char[]{'6', '3', '2', '5', '8', '7', '4'};

    public static String createHash(String password) {
        return PasswordUtil.createHash(password, DEF_ALGORITHM, 12000, 64);
    }

    public static String createHash(String password, String algorithm, int iterations, int pwdLen) {
        byte[] passwordHash = password.getBytes();
        String saltStr = PasswordUtil.randomStr(12);
        byte[] salt = saltStr.getBytes();
        byte[] hash = PasswordUtil.PBKDF2(passwordHash, salt, iterations, pwdLen, algorithm);
        return StringUtils.join((Object[])new String[]{PREFIX, String.valueOf(iterations), saltStr, PasswordUtil.toHex(hash)}, (String)SPLIT);
    }

    public static boolean validatePassword(String password, String correctHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return PasswordUtil.validatePassword(password.getBytes(), correctHash);
    }

    public static boolean validatePassword(byte[] password, String correctHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String[] params = StringUtils.split((String)correctHash, (String)SPLIT);
        int iterations = Integer.parseInt(params[1]);
        byte[] salt = params[2].getBytes();
        byte[] hash = PasswordUtil.fromHex(params[3]);
        byte[] testHash = PasswordUtil.PBKDF2(password, salt, iterations, hash.length, DEF_ALGORITHM);
        return PasswordUtil.slowEquals(hash, testHash);
    }

    private static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    public static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    public static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    public static String randomStr(int len) {
        return PasswordUtil.randomStr(len, SALT_POOL);
    }

    public static String randomStr(int len, char[] charPool) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[len];
        random.nextBytes(salt);
        char[] saltChars = new char[len];
        int poolSize = charPool.length;
        for (int i = 0; i < len; ++i) {
            saltChars[i] = charPool[(salt[i] + 128) % poolSize];
        }
        return new String(saltChars);
    }

    public static String randomPwd(int len) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[len];
        random.nextBytes(salt);
        char[] saltChars = new char[len];
        int letterPoolSize = PWD_LETTER_POOL.length;
        int numberPoolSize = PWD_NUMBER_POOL.length;
        for (int i = 0; i < len; ++i) {
            saltChars[i] = i == 0 ? PWD_LETTER_POOL[(salt[i] + 128) % letterPoolSize] : PWD_NUMBER_POOL[(salt[i] + 128) % numberPoolSize];
        }
        return new String(saltChars);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String password = "feidu888888";
        System.out.println(PasswordUtil.createHash(password));
        String str = PasswordUtil.createHash(password);
        System.out.println(PasswordUtil.validatePassword("feidu888888", str));
        System.out.println(PasswordUtil.randomStr(16));
    }

    public static byte[] PBKDF2(byte[] pwd, byte[] salt, int count, int dkLen, String algorithm) {
        Mac mac = null;
        try {
            mac = PasswordUtil.createMac(pwd, algorithm);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[dkLen];
        }
        int hLen = 32;
        int l = dkLen / hLen;
        if (dkLen % hLen != 0) {
            ++l;
        }
        byte[] allT = new byte[hLen * l];
        byte[] t = null;
        byte[] u = null;
        for (int i = 1; i <= l; ++i) {
            t = new byte[hLen];
            u = PasswordUtil.arraycat(salt, PasswordUtil.intToByteArray(i));
            for (int j = 1; j <= count; ++j) {
                u = PasswordUtil.encrypt(u, mac);
                t = PasswordUtil.xor(t, u);
            }
            System.arraycopy(t, 0, allT, (i - 1) * hLen, hLen);
        }
        byte[] result = new byte[dkLen];
        System.arraycopy(allT, 0, result, 0, dkLen);
        return result;
    }

    private static Mac createMac(byte[] key, String encName) throws NoSuchAlgorithmException, InvalidKeyException {
        if (encName == null || encName.equals("")) {
            encName = DEF_ALGORITHM;
        }
        SecretKeySpec secretKey = new SecretKeySpec(key, encName);
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac;
    }

    private static byte[] encrypt(byte[] data, Mac mac) {
        try {
            return mac.doFinal(data);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] intToByteArray(int integer) {
        int byteNum = (40 - Integer.numberOfLeadingZeros(integer < 0 ? ~integer : integer)) / 8;
        byte[] byteArray = new byte[4];
        for (int n = 0; n < byteNum; ++n) {
            byteArray[3 - n] = (byte)(integer >>> n * 8);
        }
        return byteArray;
    }

    private static byte[] arraycat(byte[] buf1, byte[] buf2) {
        byte[] bufret = null;
        int len1 = 0;
        int len2 = 0;
        if (buf1 != null) {
            len1 = buf1.length;
        }
        if (buf2 != null) {
            len2 = buf2.length;
        }
        if (len1 + len2 > 0) {
            bufret = new byte[len1 + len2];
        }
        if (len1 > 0) {
            System.arraycopy(buf1, 0, bufret, 0, len1);
        }
        if (len2 > 0) {
            System.arraycopy(buf2, 0, bufret, len1, len2);
        }
        return bufret;
    }

    private static byte[] xor(byte[] buf1, byte[] buf2) {
        byte[] temp;
        int len1 = 0;
        int len2 = 0;
        if (buf1 == null) {
            buf1 = new byte[]{};
        } else {
            len1 = buf1.length;
        }
        if (buf2 == null) {
            buf2 = new byte[]{};
        } else {
            len2 = buf2.length;
        }
        int len = 0;
        if (len1 == len2) {
            len = len1;
        } else if (len1 > len2) {
            len = len1;
            temp = new byte[len1];
            System.arraycopy(buf2, 0, temp, 0, len2);
            buf2 = temp;
        } else {
            len = len2;
            temp = new byte[len2];
            System.arraycopy(buf1, 0, temp, 0, len1);
            buf1 = temp;
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] bufret = null;
        bufret = new byte[len];
        for (int i = 0; i < len; ++i) {
            bufret[i] = (byte)(buf1[i] ^ buf2[i]);
        }
        return bufret;
    }
}

