/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.utils;

import com.baijia.doorgod.dto.Token;
import com.baijia.doorgod.po.DoorGodClient;
import com.baijia.doorgod.service.CacheClient;
import com.baijia.doorgod.utils.AES;
import com.baijia.doorgod.utils.CookieWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginUtil {
    private static final Logger logger = LoggerFactory.getLogger(LoginUtil.class);
    public static final ThreadLocal<Token> currentUser = new ThreadLocal();

    public static String getCookieValue(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        String value = CookieWrapper.getCookieValue(req, cookieName);
        return value;
    }

    public static void setCurrentUser(Token user) {
        currentUser.set(user);
    }

    public static Token getCurrentUser() {
        return currentUser.get();
    }

    public static void initCurrentUser(HttpServletRequest req, CacheClient loginCache) {
        Object user;
        String key = CookieWrapper.getCookieValue(req, "watchdog_front_ut");
        if (StringUtils.isNotBlank((CharSequence)key) && (user = loginCache.get(key)) != null) {
            if (user instanceof Token) {
                Token baseUser = (Token)user;
                LoginUtil.setCurrentUser(baseUser);
                loginCache.set(key, user, 86400L);
            } else {
                logger.error("The user is not front system.");
            }
        }
    }

    public static void refreshUserCache(HttpServletRequest req, CacheClient defultCache, Token baseUser) {
        String key = req.getParameter("watchdog_front_ut");
        LoginUtil.setCurrentUser(baseUser);
        defultCache.set(key, baseUser, 86400L);
    }

    public static void initCurrentApiUser(HttpServletRequest req, CacheClient loginCache) {
        Object user;
        String key = req.getParameter("watchdog_front_ut");
        if (StringUtils.isBlank((CharSequence)key)) {
            key = CookieWrapper.getCookieValue(req, "watchdog_front_ut");
        }
        if (StringUtils.isNotBlank((CharSequence)key) && (user = loginCache.get(key)) != null) {
            if (user instanceof Token) {
                Token baseUser = (Token)user;
                LoginUtil.setCurrentUser(baseUser);
                loginCache.set(key, user, 86400L);
            } else {
                logger.error("The user is not front system.");
            }
        }
    }

    public static void removeCurrentApiUser(HttpServletRequest request, HttpServletResponse response, CacheClient loginCache, String domain) {
        String key = request.getParameter("watchdog_front_ut");
        if (StringUtils.isBlank((CharSequence)key)) {
            key = CookieWrapper.getCookieValue(request, "watchdog_front_ut");
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            loginCache.delete(key);
            CookieWrapper.clearCookie(response, "watchdog_front_ut", domain);
        }
    }

    public static int checkLoginStatus(DoorGodClient user) {
        return user.getStatus();
    }

    public static long timeout(DoorGodClient autoLogin) {
        long timeout = 86400L;
        return timeout;
    }

    public static int expire(DoorGodClient autoLogin) {
        int expire = -1;
        return expire;
    }

    public static String getLoginTokenBaseKey(long userId) throws Exception {
        String key = AES.Encrypt(userId + "", "ZAQWSXZBERFVBGTY");
        return key;
    }
}

