/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.utils;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    public static final String CHARSET = "UTF-8";

    public static CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(20000).setSocketTimeout(20000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static String doGet(String url, Map<String, String> params) {
        return HttpClientUtils.doGet(url, params, CHARSET, null);
    }

    public static String doGet(String url, Map<String, String> params, Collection<Header> headers) {
        return HttpClientUtils.doGet(url, params, CHARSET, headers);
    }

    public static String doPost(String url, Map<String, String> params) {
        logger.info("doPost.url:{}, params:{}", (Object)url, (Object)JSONObject.fromObject(params).toString());
        return HttpClientUtils.doPost(url, params, CHARSET, null);
    }

    public static String doPost(String url, Map<String, String> params, Collection<Header> headers) {
        logger.info("doPost.url:{}, params:{}", (Object)url, (Object)JSONObject.fromObject(params).toString());
        return HttpClientUtils.doPost(url, params, CHARSET, headers);
    }

    public static String doGet(String url, Map<String, String> params, String charset) {
        return HttpClientUtils.doGet(url, params, charset, null);
    }

    public static String doGet(String url, Map<String, String> params, String charset, Collection<Header> headers) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            CloseableHttpClient httpClient;
            CloseableHttpResponse closeableHttpResponse;
            int statusCode;
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry entry : params.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair((String)entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            HttpGet httpGet = new HttpGet(url);
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpGet.addHeader(header);
                }
            }
            if ((statusCode = (closeableHttpResponse = (httpClient = HttpClientUtils.getHttpClient()).execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode()) != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = closeableHttpResponse.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            closeableHttpResponse.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPost(String url, Map<String, String> params, String charset) {
        return HttpClientUtils.doPost(url, params, charset, null);
    }

    public static String doPost(String url, Map<String, String> params, String charset, Collection<Header> headers) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            CloseableHttpClient httpClient;
            CloseableHttpResponse response;
            int statusCode;
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair((String)entry.getKey(), value));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpPost.addHeader(header);
                }
            }
            if ((statusCode = (response = (httpClient = HttpClientUtils.getHttpClient()).execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            logger.error("post error", (Throwable)e);
            return null;
        }
    }

    public static String doPost(String url, Map<String, String> params, Map<String, File> files) {
        CloseableHttpResponse response = null;
        try {
            logger.trace("doPost - start, url:{}", (Object)url);
            long start = System.currentTimeMillis();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(60000).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            long end = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: get httpClinet, cost:{}", (Object)(end - start));
            HttpPost httpPost = new HttpPost(url);
            MultipartEntity multipartEntity = new MultipartEntity();
            long getPostTime = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: getHttppOST cost:{}", (Object)(getPostTime - end));
            for (Map.Entry<String, File> entry : files.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new FileBody(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)multipartEntity);
            logger.trace("doPost - execute, url:{}", (Object)url);
            response = httpClient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            logger.trace("doPost - execute end, url:{}, status:{}", (Object)url, (Object)status);
            HttpEntity httpEntity = response.getEntity();
            String responseCont = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
            EntityUtils.consume((HttpEntity)httpEntity);
            logger.debug("doPost - url:{}, status:{}, response:{}", new Object[]{url, status, responseCont});
            return responseCont;
        }
        catch (Exception e) {
            throw new RuntimeException("dopost exception - ", e);
        }
    }

    public static void main(String[] args) throws JsonGenerationException, JsonMappingException, IOException, InterruptedException {
        HashMap params = Maps.newHashMap();
        params.put("org_id", "1");
        params.put("total_prices", "100");
        String url = "http://test-pay.genshuixue.com/purchase/createOrgSinupPurchase";
        System.out.println(HttpClientUtils.doPost(url, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doJsonPost(String url, Object params, String charset) throws Exception {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping();
        Gson gson = builder.create();
        String jsonPost = null;
        jsonPost = params instanceof String ? (String)params : gson.toJson(params);
        logger.info("url:{}, jsonPost:{}", (Object)url, (Object)jsonPost);
        HttpPost httpPost = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(jsonPost, CHARSET);
        requestEntity.setContentType("application/json");
        requestEntity.setContentEncoding(CHARSET);
        httpPost.setEntity((HttpEntity)requestEntity);
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity responseEntity = response.getEntity();
            String result = null;
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)charset);
            }
            EntityUtils.consume((HttpEntity)responseEntity);
            String string = result;
            return string;
        }
    }
}

