/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.utils;

import com.baijia.cas.client.util.JacksonUtil;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

public class EncryptUtils {
    private static final Charset charset = Charset.forName("CP437");

    public static String base64Decode(String src) {
        if (StringUtils.isBlank((String)src)) {
            return "";
        }
        String deStr = src.replace('-', '+').replace('_', '/');
        return new String(BaseEncoding.base64().decode((CharSequence)deStr), charset);
    }

    public static String strDecode(String token) {
        String src = EncryptUtils.base64Decode(token);
        char factor = src.charAt(0);
        int c = factor % 8;
        String entity = src.substring(1);
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)entity);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                int t = ch - c - i;
                if (t < 0) {
                    t += 256;
                }
                sb.append((char)t);
            }
        }
        return sb.toString();
    }

    public static String base64EncodeStrWithFactor(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        return EncryptUtils.base64EncodeStrWithFactor(JacksonUtil.obj2Str((Object)obj));
    }

    public static String base64EncodeStrWithFactor(String data) {
        Random random = new Random();
        int factor = random.nextInt((int)Math.min(255.0, Math.ceil(data.length() / 3))) + 1;
        int c = factor % 8;
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)data);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                byte t = (byte)(ch + c + i);
                sb.append(new String(new byte[]{t}, charset));
            }
        }
        String token = EncryptUtils.base64Encode(factor, sb.toString());
        return token;
    }

    public static String base64Encode(int factor, String src) {
        if (StringUtils.isBlank((String)src)) {
            return "";
        }
        src = (char)factor + src;
        String deStr = BaseEncoding.base64().encode(src.getBytes(charset));
        String result = deStr.replace('+', '-').replace('/', '_');
        while (result.endsWith("=")) {
            result = result.substring(0, result.length() - 1).toString();
        }
        return result;
    }

    public static String strEncode(String jsonParams) throws Exception {
        String str = JacksonUtil.obj2Str((Object)jsonParams);
        return EncryptUtils.base64EncodeStrWithFactor(str);
    }

    public static void main(String[] args) {
        System.out.println("\u5b66\u751f" + EncryptUtils.strDecode("A34lbGgmPjo5NzIoe3pseVp3dG4rQzqH"));
        System.out.println("\u8001\u5e08" + EncryptUtils.strDecode("A34lbGgmPjc-MSh7eWx5WXd0bStDOoc"));
        System.out.println("\u5458\u5de5" + EncryptUtils.strDecode("BoEob2ooQDg4ODMpfHttelp3dG4rQzuG"));
        System.out.println(EncryptUtils.strDecode("ASN9XyZuamMqQz49OGkwhIN2hGWDgXtzOlNKmD4"));
        String str = "{\"id\":1,\"appId\":\"16\",\"secureKey\":\"asdj123sdljfasljla\",\"timestamp\":23213423104213421}";
        System.out.println(EncryptUtils.base64EncodeStrWithFactor(str));
        String hash = "DYAnbmknPzYxJ2Z1dU5qKEAoNzwoMih5a2l7eWxSbIApQSloemtxODo7e2x0cm5pe3RydGkrNSt9cnZufH1qdnkrRDw9PDs9Pjw9Ozo-PDw-Pz08iA";
        System.out.println(EncryptUtils.strDecode(hash));
    }
}

