/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.utils;

import com.baijia.doorgod.dto.RestfulResult;
import com.baijia.doorgod.utils.HttpClientUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final String SIGN_SPLIT = "-";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String URL_SPLIT = "/";
    private static final String DEF_CHARSET = "UTF-8";

    public static String createSignData(String restMethod, String controllerName, String actionName, List<String> urlVarList, Map<String, String> params) {
        StringBuilder signData = new StringBuilder();
        signData.append(restMethod.toLowerCase());
        signData.append(SIGN_SPLIT).append(controllerName);
        signData.append(SIGN_SPLIT).append(actionName);
        if (urlVarList != null && !urlVarList.isEmpty()) {
            for (String urlVar : urlVarList) {
                if (urlVar == null) {
                    signData.append(SIGN_SPLIT).append("");
                    continue;
                }
                signData.append(SIGN_SPLIT).append(urlVar);
            }
        }
        if (params != null && !params.isEmpty()) {
            String[] paraNames = new String[params.size()];
            Arrays.sort(params.keySet().toArray(paraNames));
            for (String paraName : paraNames) {
                String value = params.get(paraName);
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = "";
                }
                signData.append(SIGN_SPLIT).append(value);
            }
        }
        return signData.toString();
    }

    public static String getSignature(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data);
        return Base64.encodeBase64String((byte[])rawHmac);
    }

    public static <T> RestfulResult<T> rest(RestMethod restMethod, String baseUrl, String controller, String action, List<String> urlVarList, Map<String, String> params, T dataType) throws Exception {
        String secureKey = params.get("secureKey");
        StringBuilder loginUrl = new StringBuilder();
        loginUrl.append(baseUrl);
        loginUrl.append(URL_SPLIT).append(controller);
        loginUrl.append(URL_SPLIT).append(action);
        String signData = CommonUtils.createSignData(restMethod.toString(), controller, action, urlVarList, params);
        String sign = CommonUtils.getSignature(signData.getBytes(DEF_CHARSET), secureKey.getBytes(DEF_CHARSET));
        params.put("sign", sign);
        log.info("loginUrl:{}, postData:{}", (Object)loginUrl.toString(), params);
        String resultJson = null;
        switch (restMethod) {
            case POST: {
                resultJson = HttpClientUtils.doPost(loginUrl.toString(), params, DEF_CHARSET);
                break;
            }
            case GET: {
                resultJson = HttpClientUtils.doGet(loginUrl.toString(), params, DEF_CHARSET);
                break;
            }
            default: {
                throw new Exception("\u4e0d\u652f\u6301\u7684REST\u65b9\u6cd5");
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        log.info("rest.resultJson:{}", (Object)resultJson);
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        RestfulResult result = null;
        if (StringUtils.isNotBlank((CharSequence)resultJson)) {
            result = (RestfulResult)mapper.readValue(resultJson, RestfulResult.class);
        } else {
            result = new RestfulResult();
            result.setCode(1);
            result.setMsg("\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38");
        }
        return result;
    }

    public static enum RestMethod {
        GET,
        POST;

    }
}

