/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.utils;

import com.baijia.cas.client.util.PropertiesReader;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(BaseUtils.class);

    public static List<String> strToList(String source, String symbol) {
        List<String> retList = null;
        if (source != null && !source.isEmpty()) {
            if (source.contains(symbol)) {
                String[] arr = source.split(symbol);
                retList = Arrays.asList(arr);
            } else {
                retList = Arrays.asList(source);
            }
        }
        return retList;
    }

    public static <T, V> List<V> getIds(List<T> objs, String property) {
        List ids = Collections.emptyList();
        for (T obj : objs) {
            ids.add(BaseUtils.getValue(obj, property));
        }
        return ids;
    }

    public static <T> String listToStr(Collection<T> list, String symbol) {
        String str = "";
        for (T s : list) {
            str = str + s;
            str = str + symbol;
        }
        if (str.length() > 0) {
            return str.substring(0, str.length() - symbol.length());
        }
        return str;
    }

    public static long strTimeToMills(String time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long millSeconds = 0L;
        try {
            millSeconds = sdf.parse(time).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return millSeconds;
    }

    public static String getFormatTime(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String unixToFormatTime(String unixTime) {
        long time = Long.parseLong(unixTime);
        String ts = new Timestamp(time * 1000L).toString();
        return ts.substring(0, ts.length() - 2);
    }

    public static String getFormatDate(String format, int offset, int field) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar cal = Calendar.getInstance();
        cal.add(field, offset);
        return sdf.format(cal.getTime());
    }

    public static Date getDate(String time, String format) {
        Date ret = null;
        if (StringUtils.isNotBlank((CharSequence)time)) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            try {
                ret = sdf.parse(time);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static String constructUserUrl(String domain, String surfix) {
        String img_server = PropertiesReader.getValue((String)"jigou", (String)"jigou.host");
        StringBuilder sb = new StringBuilder(img_server);
        return sb.append("/").append(surfix).append("/").append(domain).toString();
    }

    public static int inputCount(String input) {
        int count = 0;
        if (StringUtils.isBlank((CharSequence)input) || input == null) {
            return count;
        }
        for (int i = 0; i < input.length(); ++i) {
            if (input.substring(i, i + 1).getBytes().length == 3) {
                count += 2;
                continue;
            }
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gzipCompress(String source) {
        String target = null;
        if (source != null && !source.isEmpty()) {
            ByteArrayOutputStream out = null;
            DeflaterOutputStream gzip = null;
            try {
                out = new ByteArrayOutputStream();
                gzip = new GZIPOutputStream(out);
                gzip.write(source.getBytes());
                gzip.flush();
                ((GZIPOutputStream)gzip).finish();
                target = out.toString("ISO-8859-1");
            }
            catch (IOException e) {
                logger.error("BaseUtil.zipCompress: compress source String failed, e" + e);
            }
            finally {
                if (gzip != null) {
                    try {
                        gzip.close();
                    }
                    catch (IOException e) {
                        logger.error("BaseUtil.zipCompress: close gzipoutputstream failed, e" + e);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error("BaseUtil.zipCompress: close bytearrayoutputstream failed, e" + e);
                    }
                }
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gzipUncompress(String source) {
        String target = null;
        if (source != null && !source.isEmpty()) {
            ByteArrayOutputStream out = null;
            ByteArrayInputStream in = null;
            GZIPInputStream gunzip = null;
            try {
                int n;
                out = new ByteArrayOutputStream();
                in = new ByteArrayInputStream(source.getBytes("ISO-8859-1"));
                gunzip = new GZIPInputStream(in);
                byte[] buffer = new byte[256];
                while ((n = gunzip.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
                target = out.toString();
            }
            catch (IOException e) {
                logger.error("BaseUtil.gzipUncompress: uncompress source String failed, e" + e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error("BaseUtil.gzipUncompress: close bytearrayoutputstream failed, e" + e);
                    }
                }
                if (gunzip != null) {
                    try {
                        gunzip.close();
                    }
                    catch (IOException e) {
                        logger.error("BaseUtil.gzipUncompress: close GZIPInputStream failed, e" + e);
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error("BaseUtil.gzipUncompress: close ByteArrayInputStream failed, e" + e);
                    }
                }
            }
        }
        return target;
    }

    public static Blob strToBlob(String source, String charset) {
        SerialBlob ret = null;
        if (source != null && !source.isEmpty()) {
            try {
                ret = new SerialBlob(source.getBytes(charset));
            }
            catch (UnsupportedEncodingException | SQLException e) {
                logger.error("BaseUtils.strToBlob: string convert to blob failed," + e);
            }
        }
        return ret;
    }

    public static String blobToString(Blob source, String charset) {
        String ret = null;
        if (source != null) {
            try {
                ret = new String(source.getBytes(1L, (int)source.length()), charset);
            }
            catch (UnsupportedEncodingException | SQLException e) {
                logger.error("BaseUtils.blobToString: blob convert to String failed," + e);
            }
        }
        return ret;
    }

    public static String streamToString(InputStream sream, String charset) {
        String ret = null;
        ByteArrayOutputStream outStream = null;
        byte[] data = null;
        int count = -1;
        try {
            data = new byte[1024];
            outStream = new ByteArrayOutputStream();
            while ((count = sream.read(data, 0, 1024)) != -1) {
                outStream.write(data, 0, count);
            }
            ret = new String(outStream.toByteArray(), charset);
        }
        catch (IOException e) {
            logger.error("BaseUtils.streamToString: stream convert to String failed," + e);
        }
        return ret;
    }

    public static boolean verifyMobileNum(String number) {
        String regExp = "^[1]([3-9][0-9]{1})[0-9]{8}$";
        Pattern p = Pattern.compile(regExp);
        Matcher matcher = p.matcher(number);
        return matcher.find();
    }

    public static <T> String getStringArray(List<T> objs, String param) {
        StringBuffer sb = new StringBuffer("(");
        try {
            for (T object : objs) {
                Field field = object.getClass().getDeclaredField(param);
                field.setAccessible(true);
                Object id = field.get(object);
                sb.append(id).append(",");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String ret = "";
        if (sb.toString().endsWith(",")) {
            ret = sb.substring(0, sb.length() - 1);
        }
        ret = ret + ")";
        return ret;
    }

    public static <T> List getListFilter(List<T> objs, String param) {
        ArrayList<Object> list = new ArrayList<Object>(objs.size());
        try {
            for (T obj : objs) {
                Field field = obj.getClass().getDeclaredField(param);
                field.setAccessible(true);
                Object id = field.get(obj);
                if (id == null) continue;
                list.add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T, V> Set<V> getPropertiesList(List<T> objs, String param) {
        HashSet sets = Sets.newHashSet();
        try {
            for (T object : objs) {
                Field field = object.getClass().getDeclaredField(param);
                field.setAccessible(true);
                Object id = field.get(object);
                sets.add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sets;
    }

    public static Double doubleFormat(Double target, Integer digit) {
        BigDecimal bg = new BigDecimal(target);
        return bg.setScale((int)digit, 4).doubleValue();
    }

    public static int getCalendarField(int offset, int field) {
        Calendar cal = Calendar.getInstance();
        cal.add(field, offset);
        return cal.get(field);
    }

    public static long getInterval(String current, String source, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date currTime = null;
        Date srcTime = null;
        try {
            currTime = sdf.parse(current);
            srcTime = sdf.parse(source);
        }
        catch (ParseException e) {
            logger.error("BaseUtils.getInterval: current:{}, source:{}, format:{}", new Object[]{current, source, format});
        }
        return currTime.getTime() - srcTime.getTime();
    }

    public static <K, V> Map<K, V> listToMap(List<V> list, String param) {
        HashMap<V, V> map = new HashMap<V, V>();
        for (V v : list) {
            V key = BaseUtils.getValue(v, param);
            map.put(key, v);
        }
        return map;
    }

    public static String gbEncoding(String gbString) {
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        for (int byteIndex = 0; byteIndex < utfBytes.length; ++byteIndex) {
            String hexB = Integer.toHexString(utfBytes[byteIndex]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + "\\u" + hexB;
        }
        return unicodeBytes;
    }

    public static String decodeUnicode(String dataStr) {
        int start = 0;
        int end = 0;
        StringBuffer buffer = new StringBuffer();
        while (start > -1) {
            end = dataStr.indexOf("\\u", start + 2);
            String charStr = "";
            charStr = end == -1 ? dataStr.substring(start + 2, dataStr.length()) : dataStr.substring(start + 2, end);
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(new Character(letter).toString());
            start = end;
        }
        return buffer.toString();
    }

    public static <T, V> V getValue(T obj, String param) {
        Object ret = null;
        try {
            Field field = obj.getClass().getDeclaredField(param);
            field.setAccessible(true);
            ret = field.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (V)ret;
    }

    public static Long getLong(Number num) {
        if (num == null) {
            return null;
        }
        return num.longValue();
    }

    public static Integer getInt(Number num) {
        if (num == null) {
            return null;
        }
        return num.intValue();
    }

    public static Long getLong(Map<String, Object> map, String key) {
        if (map == null) {
            return null;
        }
        return BaseUtils.getLong((Number)map.get(key));
    }

    public static Integer getInt(Map<String, Object> map, String key) {
        if (map == null) {
            return null;
        }
        return BaseUtils.getInt((Number)map.get(key));
    }

    public static void disableCache(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
    }

    public static int str2Ascii(String source) {
        char[] chars = source.toCharArray();
        return chars[0];
    }

    public static String ascii2Str(int source) {
        return (char)source + "";
    }

    public static String getStartOfDay(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String startTimestr = df.format(date.getTime());
        startTimestr = startTimestr + " 00:00:00";
        return startTimestr;
    }

    public static Date getStartOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(6, 1);
        cal.set(2, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String getEndOfDay(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String endTimestr = df.format(date.getTime());
        endTimestr = endTimestr + " 23:59:59";
        return endTimestr;
    }

    public static Date getFirstDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static int getDayOfWeek(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int dayOfWeek = 0;
        dayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
        return dayOfWeek;
    }

    public static Date getLastDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 1);
        cal.add(3, 1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String maskMobile(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(mobile);
        int len = sb.length();
        int end = len - 5;
        int start = end - 3;
        for (int i = 0; i < len; ++i) {
            if (i < start || i > end) continue;
            sb.setCharAt(i, '*');
        }
        return sb.toString();
    }

    public static boolean overlapDetect(Date srcStartTime, Date srcEndTime, Date destStartTime, Date destEndTime) {
        if (srcStartTime.getTime() == destStartTime.getTime() || srcStartTime.getTime() == destEndTime.getTime() || srcEndTime.getTime() == destStartTime.getTime() || srcEndTime.getTime() == destEndTime.getTime()) {
            return true;
        }
        return destStartTime.after(srcStartTime) && destStartTime.before(srcEndTime) || destEndTime.after(srcStartTime) && destEndTime.before(srcEndTime) || srcStartTime.after(destStartTime) && srcStartTime.before(destEndTime) || srcEndTime.after(destStartTime) && srcEndTime.before(destEndTime);
    }

    public static void main(String[] args) {
        System.out.println(BaseUtils.getFirstDayOfWeek());
        System.out.println(BaseUtils.getLastDayOfWeek());
        System.out.println(new Date(1466816400000L));
        System.out.println(BaseUtils.getDayOfWeek(new Date(1466827200000L)));
        System.out.println("--------------------");
        for (int i = 0; i < 10; ++i) {
            System.out.println(RandomUtils.nextInt((int)0, (int)5));
        }
    }
}

