/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.service.impl;

import com.baijia.doorgod.dao.DoorGodApplicationDao;
import com.baijia.doorgod.dao.DoorGodClientDao;
import com.baijia.doorgod.dao.DoorGodUserDao;
import com.baijia.doorgod.dto.Token;
import com.baijia.doorgod.enums.UserStatus;
import com.baijia.doorgod.po.DoorGodApplication;
import com.baijia.doorgod.po.DoorGodClient;
import com.baijia.doorgod.po.DoorGodUser;
import com.baijia.doorgod.service.CacheClient;
import com.baijia.doorgod.service.DoorGodApplicationService;
import com.baijia.doorgod.utils.CommonUtils;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class DoorGodApplicationServiceImpl
implements DoorGodApplicationService {
    private static final String DEF_CHARSET = "UTF-8";
    @Autowired
    private DoorGodApplicationDao doorGodApplicationDao;
    @Autowired
    private DoorGodClientDao doorGodClientDao;
    @Autowired
    private DoorGodUserDao doorGodUserDao;
    @Autowired
    private CacheClient defaultCache;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Token auth(Map<String, String> params) throws Exception {
        String appId = params.get("appId");
        String secureKey = params.get("secureKey");
        String sourceSign = params.get("sign");
        params.remove("sign");
        String str = CommonUtils.createSignData(RequestMethod.POST.toString(), "", "auth", null, params);
        String sign = CommonUtils.getSignature(str.getBytes(DEF_CHARSET), secureKey.getBytes(DEF_CHARSET));
        Date now = new Date();
        if (sign.equals(sourceSign)) {
            DoorGodApplication app = this.doorGodApplicationDao.getAppByParams(appId, secureKey);
            if (app != null && app.getStatus() == UserStatus.NORMAL.getStatus()) {
                Long applicationId = app.getId();
                String orgId = params.get("orgId");
                Long userId = Long.parseLong(params.get("userId"));
                int userRole = Integer.parseInt(params.get("userRole"));
                DoorGodClient client = this.doorGodClientDao.getClientByParams(applicationId, StringUtils.isNotBlank((CharSequence)orgId) ? Long.valueOf(Long.parseLong(orgId)) : null);
                Token token = null;
                if (client != null && client.getStatus() == UserStatus.NORMAL.getStatus() && now.before(client.getExpireTime()) && now.after(client.getStartTime())) {
                    DoorGodUser user = this.doorGodUserDao.getUserByParams(client.getId(), userId, userRole);
                    String cover = params.get("cover");
                    String userName = params.get("userName");
                    Integer systemType = Integer.parseInt(params.get("systemType"));
                    if (user != null) {
                        if (user.getStatus() == UserStatus.NORMAL.getStatus()) {
                            token = new Token();
                            token.setId(user.getId());
                            token.setCover(cover);
                            token.setClientId(client.getId());
                            token.setOrgId(client.getOrgId());
                            token.setSystemType(systemType);
                            token.setTimestamp(now.getTime());
                            token.setUserId(user.getUserId());
                            token.setUserRole(user.getUserRole());
                            token.setUserName(userName);
                            token.setCallBackUrl(app.getDomain());
                            return token;
                        }
                        throw new Exception("\u65e0\u6743\u8bbf\u95ee-\u7528\u6237\u6743\u9650\u88ab\u7981\u7528");
                    }
                    user = new DoorGodUser();
                    user.setClientId(client.getId());
                    user.setCover(cover);
                    user.setCreateTime(now);
                    user.setStatus(UserStatus.NORMAL.getStatus());
                    user.setUpdateTime(now);
                    user.setUserId(userId);
                    user.setUserName(userName);
                    user.setUserRole(userRole);
                    this.doorGodUserDao.save(user, new String[0]);
                    token = new Token();
                    token.setId(user.getId());
                    token.setCover(cover);
                    token.setOrgId(client.getOrgId());
                    token.setSystemType(systemType);
                    token.setTimestamp(now.getTime());
                    token.setUserId(user.getUserId());
                    token.setUserRole(user.getUserRole());
                    token.setUserName(userName);
                    token.setCallBackUrl(app.getDomain());
                    return token;
                }
                throw new Exception("\u65e0\u6743\u8bbf\u95ee-\u673a\u6784\u672a\u5f00\u901a\u6216\u6743\u9650\u5df2\u8fc7\u671f");
            }
            throw new Exception("\u65e0\u6743\u8bbf\u95ee-\u5c1a\u672a\u5f00\u901a\u5bf9\u5e94\u7684\u529f\u80fd\u6743\u9650");
        }
        throw new Exception("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
    }
}

