/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.filter;

import com.baijia.cas.client.util.JacksonUtil;
import com.baijia.doorgod.dto.AppBaseResponse;
import com.baijia.doorgod.dto.Token;
import com.baijia.doorgod.utils.IpUtil;
import com.baijia.doorgod.utils.LoginUtil;
import com.baijia.doorgod.utils.RequestUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AccessControlFilter.class);
    private static String[] excludePages = new String[]{"/logout.json"};
    private static String[] excludeSuffixeds = new String[]{".task", ".ajax", ".ignore", ".js", ".css", ".html"};
    private static Set<String> excludePageSet = new HashSet<String>();
    private static Set<String> excludeSuffixedSet = new HashSet<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        try {
            Token user = LoginUtil.getCurrentUser();
            if (user != null) {
                String params = RequestUtil.getParams(httpRequest);
                String ipStr = IpUtil.getIpAddr(httpRequest);
                if (log.isDebugEnabled()) {
                    log.debug("[InnocentRequestFilter] ,path: " + path + ",ip=" + ipStr + ",params=" + params);
                } else {
                    log.info("[InnocentRequestFilter], path: " + path + ",ip=" + ipStr + ",params=" + params);
                }
            } else {
                this.makeJumpResponse((OutputStream)response.getOutputStream());
            }
        }
        catch (Exception e) {
            log.error("InnocentRequestFilter.error," + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        if (this.inWhiteList(path)) {
            request.getRequestDispatcher(path).forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean inWhiteList(String path) {
        if (excludePageSet.contains(path)) {
            return true;
        }
        for (String excludeSuffixed : excludeSuffixedSet) {
            if (!path.endsWith(excludeSuffixed)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    private void makeJumpResponse(OutputStream out) {
        try {
            JacksonUtil.writeObj((OutputStream)out, (Object)new AppBaseResponse("", 0L, null));
        }
        catch (IOException e) {
            log.error("Write jump-response object to json error...", (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    static {
        log.info("Init AuthorityFilter");
        for (String excludePage : excludePages) {
            excludePageSet.add(excludePage);
        }
        for (String excludeSuffixed : excludeSuffixeds) {
            excludeSuffixedSet.add(excludeSuffixed);
        }
    }
}

