/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.doorgod.controller;

import com.baijia.doorgod.dto.Token;
import com.baijia.doorgod.service.CacheClient;
import com.baijia.doorgod.service.DoorGodApplicationService;
import com.baijia.doorgod.utils.CommonUtils;
import com.baijia.doorgod.utils.CookieWrapper;
import com.baijia.doorgod.utils.LoginUtil;
import com.baijia.doorgod.utils.ResponseUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;

@RequestMapping(value={"/authrization"})
@Controller
public class DoorGodAuthController {
    private static final Logger log = LoggerFactory.getLogger(DoorGodAuthController.class);
    private static final String DEF_CHARSET = "UTF-8";
    @Autowired
    private DoorGodApplicationService doorGodApplicationService;
    @Autowired
    private CacheClient defaultCache;

    @RequestMapping(value={"/auth.do"})
    public ModelAndView auth(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String secureKey = req.getParameter("secureKey");
            HashMap params = Maps.newHashMap();
            Enumeration elements = req.getParameterNames();
            log.info("auth.do.params:{}", (Object)params);
            while (elements.hasMoreElements()) {
                String key = (String)elements.nextElement();
                params.put(key, req.getParameter(key));
            }
            String sourceSign = (String)params.get("sign");
            params.remove("sign");
            String str = CommonUtils.createSignData(RequestMethod.POST.toString(), "", "auth", null, params);
            String sign = CommonUtils.getSignature(str.getBytes(DEF_CHARSET), secureKey.getBytes(DEF_CHARSET));
            if (sign.equals(sourceSign)) {
                Token token = this.doorGodApplicationService.auth(params);
                if (token != null) {
                    String redirectUrl = (String)params.get("redirectUrl");
                    String encrypt = token.getEncrytToken();
                    CookieWrapper.setCookie(resp, "watchdog_front_ut", encrypt, req.getServerName(), 86400);
                    LoginUtil.setCurrentUser(token);
                    return new ModelAndView((View)new InternalResourceView(redirectUrl));
                }
                return new ModelAndView((View)new InternalResourceView("/noauth.html"));
            }
            return new ModelAndView((View)new InternalResourceView("/noauth.html"));
        }
        catch (Exception e) {
            ResponseUtil.write(resp, e.getMessage());
            return null;
        }
    }

    void validate(Map<String, String> params) {
        String systemType = params.get("systemType");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)systemType), (Object)"\u7cfb\u7edf\u7c7b\u578b\u53c2\u6570systemType\u8bbe\u7f6e\u4e0d\u6b63\u786e");
    }
}

