/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.adserver.web.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final Logger logger = LoggerFactory.getLogger(CookieUtil.class);

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String domain, String path, int expires) {
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        cookie.setMaxAge(expires);
        response.addCookie(cookie);
        logger.debug("addCookie - name:{}, value:{}, domain:{}, path:{}, expires:{}", new Object[]{name, value, domain, path, expires});
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String name, String domain) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(name)) continue;
            cookie.setDomain(domain);
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            return;
        }
    }
}

