/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.adserver.web.response;

import com.baijia.adserver.base.Ad;
import com.baijia.adserver.base.AdCookie;
import com.baijia.adserver.base.AdResponse;
import com.baijia.adserver.base.conf.AdServerProperties;
import com.baijia.adserver.base.constant.ErrorCode;
import com.baijia.adserver.web.PageResponse;
import com.baijia.adserver.web.response.PageResponseBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageResponseBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PageResponseBuilder.class);
    private AdResponse adResponse;

    public PageResponseBuilder(AdResponse adResponse) {
        this.adResponse = adResponse;
    }

    public PageResponse build() {
        return this.build(false);
    }

    public PageResponse build(boolean isSetCookie) {
        PageResponse pageResponse = new PageResponse();
        pageResponse.setStatus(ErrorCode.OK.getCode());
        pageResponse.setData((Object)this.buildAdMap());
        if (isSetCookie) {
            pageResponse.setCookie((Object)this.buildCookie());
        }
        return pageResponse;
    }

    private Map<Integer, List<AdItem>> buildAdMap() {
        HashMap adMap = Maps.newHashMap();
        for (Map.Entry entry : this.adResponse.getAdMap().entrySet()) {
            Integer adposId = (Integer)entry.getKey();
            List adList = (List)entry.getValue();
            List templateList = this.buildAdItemList(adposId, adList);
            adMap.put(adposId, templateList);
        }
        return adMap;
    }

    private List<AdItem> buildAdItemList(Integer adposId, List<Ad> adList) {
        ArrayList itemList = Lists.newArrayList();
        for (Ad ad : adList) {
            AdItem item = this.buildAdItem(ad);
            itemList.add(item);
        }
        if (itemList.size() == 0) {
            itemList.add(this.buildEmptyAdItem(adposId));
        }
        return itemList;
    }

    private AdItem buildAdItem(Ad ad) {
        AdItem item = new AdItem(this, null);
        item.setMaterial(ad.getMaterialUrl());
        item.setHover(ad.getMaterialHover());
        item.setMonitor(this.genMonitor(ad));
        item.setClick(this.genClick(ad));
        return item;
    }

    private AdItem buildEmptyAdItem(Integer adposId) {
        AdItem item = new AdItem(this, null);
        item.setMaterial("");
        item.setHover("");
        item.setMonitor(this.genMonitor(adposId));
        item.setClick("");
        return item;
    }

    private Map<String, AdCookie> buildCookie() {
        return this.adResponse.getAdCookieMap();
    }

    private String genMonitor(Ad ad) {
        String monitor = AdServerProperties.getProperty((String)"logserver.monitor.intf");
        StringBuilder sb = new StringBuilder();
        sb.append(monitor);
        sb.append("?p=").append(ad.getAdposId());
        sb.append("&b=").append(ad.getAdbarId());
        sb.append("&g=").append(ad.getAdgroupId());
        sb.append("&c=").append(ad.getCreativeId());
        return sb.toString();
    }

    private String genMonitor(Integer adposId) {
        String monitor = AdServerProperties.getProperty((String)"logserver.monitor.intf");
        StringBuilder sb = new StringBuilder();
        sb.append(monitor);
        sb.append("?p=").append(adposId);
        sb.append("&b=");
        sb.append("&g=");
        sb.append("&c=");
        return sb.toString();
    }

    private String genClick(Ad ad) {
        String click = AdServerProperties.getProperty((String)"logserver.click.intf");
        StringBuilder sb = new StringBuilder();
        sb.append(click);
        sb.append("?p=").append(ad.getAdposId());
        sb.append("&b=").append(ad.getAdbarId());
        sb.append("&g=").append(ad.getAdgroupId());
        sb.append("&c=").append(ad.getCreativeId());
        return sb.toString();
    }
}

