/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.adserver.web.controller;

import com.baijia.adserver.base.Ad;
import com.baijia.adserver.base.constant.ErrorCode;
import com.baijia.adserver.index.AdIndexManager;
import com.baijia.adserver.index.TargetIndexManager;
import com.baijia.adserver.web.PageResponse;
import com.baijia.adserver.web.param.DebugParam;
import com.baijia.commons.lang.utils.date.FormatDateUtils;
import com.baijia.commons.lang.utils.http.ResponseUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/debug"})
public class DebugController {
    private static final Logger logger = LoggerFactory.getLogger(DebugController.class);
    @Resource
    private AdIndexManager adIndexManager;
    @Resource
    private TargetIndexManager targetIndexManager;

    @RequestMapping(value={"/cache"}, method={RequestMethod.GET})
    @ResponseBody
    public void debug(HttpServletRequest request, HttpServletResponse response, DebugParam param) {
        try {
            logger.info("debug cache - param:{}", (Object)param);
            response.setContentType("application/json");
            if (StringUtils.isBlank((CharSequence)param.getP())) {
                PageResponse pageResponse = new PageResponse(ErrorCode.PARAM_ERROR);
                ResponseUtil.send((HttpServletResponse)response, (String)pageResponse.toJson());
                return;
            }
            Integer adposId = Integer.parseInt(param.getP());
            String date = param.getCt();
            if (StringUtils.isBlank((CharSequence)date)) {
                date = FormatDateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
            }
            List adList = this.adIndexManager.getAdList(date, adposId);
            ArrayList adgroupIdList = Lists.newArrayList();
            for (Ad ad : adList) {
                adgroupIdList.add(ad.getAdgroupId());
            }
            ArrayList adTargetList = Lists.newArrayList();
            for (Integer adgroupId : adgroupIdList) {
                Map adTarget = this.targetIndexManager.getAdTarget(date, adgroupId);
                HashMap adgroupTargetMap = Maps.newHashMap();
                adgroupTargetMap.put(adgroupId, adTarget);
                if (adTargetList.contains(adgroupTargetMap)) continue;
                adTargetList.add(adgroupTargetMap);
            }
            HashMap map = Maps.newHashMap();
            map.put("\u5e7f\u544a", adList);
            map.put("\u5b9a\u5411", adTargetList);
            Gson gson = new Gson();
            gson.toJson((Object)map);
            ResponseUtil.send((HttpServletResponse)response, (String)gson.toJson((Object)map));
        }
        catch (Exception e) {
            logger.error("debug exception - ", (Throwable)e);
            PageResponse pageResponse = new PageResponse(ErrorCode.SYSTEM_ERROR);
            ResponseUtil.send((HttpServletResponse)response, (String)pageResponse.toJson());
        }
    }
}

