/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.adserver.web.controller;

import com.baijia.adserver.base.AdCookie;
import com.baijia.adserver.base.AdRequest;
import com.baijia.adserver.base.AdResponse;
import com.baijia.adserver.base.constant.ErrorCode;
import com.baijia.adserver.selector.AdSelector;
import com.baijia.adserver.web.PageRequest;
import com.baijia.adserver.web.PageResponse;
import com.baijia.adserver.web.PageServerRequest;
import com.baijia.adserver.web.param.PageParam;
import com.baijia.adserver.web.response.PageResponseBuilder;
import com.baijia.adserver.web.utils.CookieUtil;
import com.baijia.commons.lang.utils.date.FormatDateUtils;
import com.baijia.commons.lang.utils.http.ResponseUtil;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdRequestController {
    private static final Logger logger = LoggerFactory.getLogger(AdRequestController.class);
    @Resource
    private AdSelector selector;

    @RequestMapping(value={"/p.json"}, method={RequestMethod.GET})
    @ResponseBody
    public void pageJson(HttpServletRequest request, HttpServletResponse response, PageParam param) {
        try {
            logger.trace("pageJson - param:{}", (Object)param);
            this.setDefaultParam(param);
            response.setContentType("text/javascript");
            response.addHeader("Access-Control-Allow-Origin", "*");
            PageResponse pageResponse = this.validatePageRequest(param);
            if (pageResponse != null) {
                ResponseUtil.send((HttpServletResponse)response, (String)pageResponse.toJson());
                return;
            }
            PageRequest adRequest = new PageRequest(request, param);
            pageResponse = this.page((AdRequest)adRequest, response, false);
            ResponseUtil.send((HttpServletResponse)response, (String)this.toJsonp(param.getCallback(), pageResponse));
        }
        catch (Exception e) {
            logger.error("p.json exception - ", (Throwable)e);
            PageResponse pageResponse = new PageResponse(ErrorCode.SYSTEM_ERROR);
            ResponseUtil.send((HttpServletResponse)response, (String)pageResponse.toJson());
        }
    }

    private String toJsonp(String cbf, PageResponse pageResponse) {
        if (StringUtils.isNotBlank((CharSequence)cbf)) {
            StringBuilder sb = new StringBuilder();
            sb.append(cbf).append("(");
            sb.append(pageResponse.toJson());
            sb.append(")");
            return sb.toString();
        }
        return pageResponse.toJson();
    }

    @RequestMapping(value={"/ps.json"}, method={RequestMethod.GET})
    @ResponseBody
    public void pageServerJson(HttpServletRequest request, HttpServletResponse response, PageParam param) {
        try {
            logger.trace("pageServerJson - param:{}", (Object)param);
            this.setDefaultParam(param);
            response.setContentType("application/json");
            PageResponse pageResponse = this.validatePageServerRequest(param);
            if (pageResponse != null) {
                ResponseUtil.send((HttpServletResponse)response, (String)pageResponse.toJson());
                return;
            }
            PageServerRequest adRequest = new PageServerRequest(request, param);
            pageResponse = this.page((AdRequest)adRequest, response, true);
            ResponseUtil.send((HttpServletResponse)response, (String)pageResponse.toJson());
        }
        catch (Exception e) {
            logger.error("ps.json exception - ", (Throwable)e);
            PageResponse pageResponse = new PageResponse(ErrorCode.SYSTEM_ERROR);
            ResponseUtil.send((HttpServletResponse)response, (String)pageResponse.toJson());
        }
    }

    private void setDefaultParam(PageParam param) {
        param.setProt("json");
        if (StringUtils.isBlank((CharSequence)param.getCt())) {
            String today = FormatDateUtils.formatDate((String)"yyyy-MM-dd");
            param.setCt(today);
        }
    }

    private PageResponse page(AdRequest request, HttpServletResponse response, boolean isServerRequest) {
        AdResponse adResponse = this.selector.select(request);
        if (!isServerRequest) {
            this.handleCookie(response, adResponse);
        }
        PageResponse pageResponse = new PageResponseBuilder(adResponse).build(isServerRequest);
        return pageResponse;
    }

    private PageResponse validatePageRequest(PageParam param) {
        if (StringUtils.isBlank((CharSequence)param.getP())) {
            PageResponse pageResponse = new PageResponse(ErrorCode.PARAM_ERROR);
            return pageResponse;
        }
        return null;
    }

    private PageResponse validatePageServerRequest(PageParam param) {
        return this.validatePageRequest(param);
    }

    private void handleCookie(HttpServletResponse response, AdResponse adResponse) {
        Map adCookieMap = adResponse.getAdCookieMap();
        for (Map.Entry entry : adCookieMap.entrySet()) {
            AdCookie adCookie = (AdCookie)entry.getValue();
            this.addCookie(response, adCookie);
        }
    }

    private void addCookie(HttpServletResponse response, AdCookie adCookie) {
        String name = adCookie.getName();
        String value = adCookie.getValue();
        String domain = adCookie.getDomain();
        String path = adCookie.getPath();
        int expires = adCookie.getExpire();
        CookieUtil.addCookie((HttpServletResponse)response, (String)name, (String)value, (String)domain, (String)path, (int)expires);
    }
}

