/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.adserver.web;

import com.baijia.adserver.base.AdRequest;
import com.baijia.adserver.web.param.PageParam;
import com.baijia.adserver.web.utils.CookieUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRequest
extends AdRequest {
    private static final Logger logger = LoggerFactory.getLogger(PageRequest.class);
    private static Map<String, String> attrMap = Maps.newHashMap();

    public PageRequest() {
    }

    public PageRequest(HttpServletRequest request, PageParam param) {
        this.initContext(request);
        this.initParam(param);
    }

    protected void initContext(HttpServletRequest request) {
        this.initAdbarTurn(request);
        this.initCreativeTurn(request);
    }

    private void initAdbarTurn(HttpServletRequest request) {
        String[] turns;
        String value = this.getAdbarTurnValue(request);
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        for (String turn : turns = value.split(",")) {
            String[] posBarseq = turn.split("_");
            if (posBarseq.length != 2) {
                logger.warn("invalid bar turn: " + turn);
                continue;
            }
            try {
                Integer adposId = Integer.valueOf(posBarseq[0]);
                Integer barSeq = Integer.valueOf(posBarseq[1]);
                this.setBarTurn(adposId, barSeq);
            }
            catch (NumberFormatException e) {
                logger.warn("invalid bar turn: " + turn);
            }
        }
    }

    private void initCreativeTurn(HttpServletRequest request) {
        String[] turns;
        String value = this.getCreativeTurnValue(request);
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        for (String turn : turns = value.split(",")) {
            String[] adgroupCreativeSeq = turn.split("_");
            if (adgroupCreativeSeq.length != 2) {
                logger.warn("invalid creative turn: " + turn);
                continue;
            }
            try {
                Integer adgroupId = Integer.valueOf(adgroupCreativeSeq[0]);
                Integer creativeSeq = Integer.valueOf(adgroupCreativeSeq[1]);
                this.setCreativeTurn(adgroupId, creativeSeq);
            }
            catch (NumberFormatException e) {
                logger.warn("invalid creative turn: " + turn);
            }
        }
    }

    protected String getAdbarTurnValue(HttpServletRequest request) {
        return this.getCookieValue(request, "bturn");
    }

    protected String getCreativeTurnValue(HttpServletRequest request) {
        return this.getCookieValue(request, "cturn");
    }

    private String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, (String)cookieName);
        if (cookie == null) {
            return "";
        }
        String value = cookie.getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        logger.debug("cookie turn value, name:{}, value:{}", (Object)cookieName, (Object)value);
        return value.trim();
    }

    protected void initParam(PageParam param) {
        this.initBaseParam(param);
        this.initPageParam(param);
    }

    private void initBaseParam(PageParam param) {
        this.initDate(param.getCt());
        this.initAdpos(param.getP());
    }

    private void initDate(String ct) {
        if (StringUtils.isBlank((CharSequence)ct)) {
            return;
        }
        this.setDate(ct);
    }

    private void initAdpos(String adpos) {
        String[] posIdsInStr = adpos.split(",");
        ArrayList adposIdList = Lists.newArrayList();
        for (String adposId : posIdsInStr) {
            try {
                adposIdList.add(Integer.parseInt(adposId));
            }
            catch (NumberFormatException e) {
                logger.warn("invalid posId:{} in adpos:{}", (Object)adposId, (Object)adpos);
            }
        }
        Integer[] adposIds = new Integer[adposIdList.size()];
        adposIdList.toArray(adposIds);
        this.setAdposIds(adposIds);
    }

    private void initPageParam(PageParam param) {
        logger.trace("init page param:{}", (Object)param);
        Set attrs = attrMap.keySet();
        for (String attr : attrs) {
            Field field = this.getField(attr);
            if (field == null) continue;
            try {
                String value = (String)field.get(param);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                String category = (String)attrMap.get(attr);
                this.setAssignment(category, value);
                logger.debug("init page param: {} -> {} = {}", new Object[]{category, attr, value});
            }
            catch (Exception e) {
                logger.warn("init page param exception - ", (Throwable)e);
            }
        }
    }

    private Field getField(String name) {
        Field[] fields;
        for (Field field : fields = PageParam.class.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    static {
        attrMap.put("ss", "subsite");
        attrMap.put("sj", "subject");
    }
}

