/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerCallItemSafetyCheck;
import com.azure.ai.openai.responses.models.ResponsesComputerCallOutputItemOutput;
import com.azure.ai.openai.responses.models.ResponsesComputerCallOutputItemStatus;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResponsesComputerCallOutputItem
extends ResponsesItem {
    private ResponsesItemType type = ResponsesItemType.COMPUTER_CALL_OUTPUT;
    private final String callId;
    private final List<ResponsesComputerCallItemSafetyCheck> acknowledgedSafetyChecks;
    private final ResponsesComputerCallOutputItemOutput output;
    private ResponsesComputerCallOutputItemStatus status;

    public ResponsesComputerCallOutputItem(String callId, List<ResponsesComputerCallItemSafetyCheck> acknowledgedSafetyChecks, ResponsesComputerCallOutputItemOutput output) {
        this.callId = callId;
        this.acknowledgedSafetyChecks = acknowledgedSafetyChecks;
        this.output = output;
    }

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    public String getCallId() {
        return this.callId;
    }

    public List<ResponsesComputerCallItemSafetyCheck> getAcknowledgedSafetyChecks() {
        return this.acknowledgedSafetyChecks;
    }

    public ResponsesComputerCallOutputItemOutput getOutput() {
        return this.output;
    }

    public ResponsesComputerCallOutputItemStatus getStatus() {
        return this.status;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("call_id", this.callId);
        jsonWriter.writeArrayField("acknowledged_safety_checks", this.acknowledgedSafetyChecks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("output", (JsonSerializable)this.output);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesComputerCallOutputItem fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesComputerCallOutputItem)jsonReader.readObject(reader -> {
            String id = null;
            String callId = null;
            List acknowledgedSafetyChecks = null;
            ResponsesComputerCallOutputItemOutput output = null;
            ResponsesItemType type = ResponsesItemType.COMPUTER_CALL_OUTPUT;
            ResponsesComputerCallOutputItemStatus status = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("call_id".equals(fieldName)) {
                    callId = reader.getString();
                    continue;
                }
                if ("acknowledged_safety_checks".equals(fieldName)) {
                    acknowledgedSafetyChecks = reader.readArray(reader1 -> ResponsesComputerCallItemSafetyCheck.fromJson(reader1));
                    continue;
                }
                if ("output".equals(fieldName)) {
                    output = ResponsesComputerCallOutputItemOutput.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesComputerCallOutputItemStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesComputerCallOutputItem deserializedResponsesComputerCallOutputItem = new ResponsesComputerCallOutputItem(callId, acknowledgedSafetyChecks, output);
            deserializedResponsesComputerCallOutputItem.setId(id);
            deserializedResponsesComputerCallOutputItem.type = type;
            deserializedResponsesComputerCallOutputItem.status = status;
            return deserializedResponsesComputerCallOutputItem;
        });
    }
}

