/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.oss.ossbuilder.builders;

import com.anji.plus.gaea.oss.config.OSSProperties;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSException;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSExceptionBuilder;
import com.anji.plus.gaea.oss.ossbuilder.GaeaOSSTemplate;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class NFSClient
implements GaeaOSSTemplate {
    private static Logger logger = LoggerFactory.getLogger(NFSClient.class);
    private String nfsLocalStore = "/app/disk/upload";
    private String fileTypeWhiteList;

    @Override
    public String getFileTypeWhiteList() {
        return this.fileTypeWhiteList;
    }

    public NFSClient(OSSProperties ossProperties) {
        File localDir;
        this.fileTypeWhiteList = ossProperties.getFileTypeWhiteList();
        if (ossProperties.getNfs() != null && !StringUtils.isEmpty((Object)ossProperties.getNfs().getPath())) {
            this.nfsLocalStore = ossProperties.getNfs().getPath();
        }
        if (!StringUtils.endsWithIgnoreCase((String)this.nfsLocalStore, (String)File.separator)) {
            this.nfsLocalStore = this.nfsLocalStore + File.separator;
        }
        if (!(localDir = new File(this.nfsLocalStore)).exists()) {
            localDir.mkdirs();
        }
        logger.info("\u521d\u59cb\u5316\u6587\u4ef6\u5b58\u50a8\uff0c\u6fc0\u6d3b\u670d\u52a1\u5668\u672c\u5730\u6587\u4ef6\u5b58\u50a8\uff0c\u8def\u5f84{}", (Object)this.nfsLocalStore);
    }

    @Override
    public String uploadFileByInputStream(MultipartFile file, String fileObjectName) throws GaeaOSSException {
        this.checkFileSuffixName(file);
        File objectFile = null;
        try {
            String filePath = this.nfsLocalStore + fileObjectName;
            objectFile = new File(filePath);
            file.transferTo(objectFile);
        }
        catch (Exception e) {
            logger.error("save file to local store error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("save file to local store error", e);
        }
        finally {
            objectFile = null;
        }
        return fileObjectName;
    }

    @Override
    public byte[] downloadFile(String fileObjectName) throws GaeaOSSException {
        byte[] fileBytes = null;
        File objectFile = null;
        try {
            String filePath = this.nfsLocalStore + fileObjectName;
            objectFile = new File(filePath);
            fileBytes = FileUtils.readFileToByteArray((File)objectFile);
        }
        catch (Exception e) {
            logger.error("read file from local store error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("read file from local store error, objectName=" + fileObjectName);
        }
        finally {
            objectFile = null;
        }
        return fileBytes;
    }

    @Override
    public void deleteFile(String fileObjectName) {
        try {
            String filePath = this.nfsLocalStore + fileObjectName;
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteFiles(List<String> fileObjectNames) {
        if (CollectionUtils.isEmpty(fileObjectNames)) {
            return;
        }
        fileObjectNames.stream().forEach(fileObjectName -> this.deleteFile((String)fileObjectName));
    }
}

