/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.oss.ossbuilder.builders;

import com.anji.plus.gaea.oss.config.OSSProperties;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSException;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSExceptionBuilder;
import com.anji.plus.gaea.oss.ossbuilder.GaeaOSSTemplate;
import com.obs.services.ObsClient;
import com.obs.services.model.ObsObject;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class HuaweiOBSClient
implements GaeaOSSTemplate {
    private String bucketName;
    private String fileTypeWhiteList;
    private ObsClient ossClient;

    public HuaweiOBSClient(OSSProperties properties) {
        this.init(properties);
    }

    @Override
    public void init(OSSProperties config) {
        this.ossClient = new ObsClient(config.getHuaweiObs().getAccessKey(), config.getHuaweiObs().getSecretKey(), config.getHuaweiObs().getUrl());
        this.bucketName = config.getHuaweiObs().getBucketName();
        this.fileTypeWhiteList = config.getFileTypeWhiteList();
    }

    @Override
    public void close() {
        if (this.ossClient != null) {
            try {
                this.ossClient.close();
            }
            catch (Exception ex) {
                logger.error("close-client-err:{}", (Throwable)ex);
            }
            logger.info("shutdown-oss-client");
        }
    }

    @Override
    public String getFileTypeWhiteList() {
        return this.fileTypeWhiteList;
    }

    @Override
    public String uploadFileByInputStream(MultipartFile file, String fileObjectName) throws GaeaOSSException {
        this.checkFileSuffixName(file);
        InputStream fileInputStream = null;
        try {
            this.ossClient.putObject(this.bucketName, fileObjectName, file.getInputStream());
        }
        catch (Exception e) {
            logger.error("save file error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("save file error", e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("close InputStream error:", (Throwable)e);
            }
        }
        return fileObjectName;
    }

    @Override
    public byte[] downloadFile(String fileObjectName) throws GaeaOSSException {
        byte[] fileBytes = null;
        InputStream inputStream = null;
        try {
            ObsObject obsObject = this.ossClient.getObject(this.bucketName, fileObjectName);
            if (obsObject == null) {
                logger.error("file {} not exist in minio store ", (Object)fileObjectName);
                throw GaeaOSSExceptionBuilder.build("file not exist,objectName=" + fileObjectName);
            }
            inputStream = obsObject.getObjectContent();
            fileBytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error("read file error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("read file error, objectName=" + fileObjectName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return fileBytes;
    }

    @Override
    public void deleteFile(String fileObjectName) {
        try {
            this.ossClient.deleteObject(this.bucketName, fileObjectName);
        }
        catch (Exception e) {
            logger.warn("delete file fail, bucket={}, file={}", (Object)this.bucketName, (Object)fileObjectName);
        }
    }

    @Override
    public void deleteFiles(List<String> fileObjectNames) {
        if (CollectionUtils.isEmpty(fileObjectNames)) {
            return;
        }
        fileObjectNames.stream().forEach(this::deleteFile);
    }
}

