/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.oss.ossbuilder;

import com.anji.plus.gaea.oss.config.OSSProperties;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSException;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSTypeLimitedExceptionBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public interface GaeaOSSTemplate {
    public static final Logger logger = LoggerFactory.getLogger(GaeaOSSTemplate.class);

    default public void init(OSSProperties config) {
    }

    default public void close() {
    }

    public String getFileTypeWhiteList();

    default public List<String> splitToList(String listStr) {
        List<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)listStr)) {
            return list;
        }
        if (listStr.contains("|")) {
            list = Arrays.asList(listStr.split("\\|"));
        }
        if (listStr.contains(",")) {
            list = Arrays.asList(listStr.split(","));
        }
        ArrayList<String> upperList = new ArrayList<String>();
        upperList.addAll(list.stream().map(String::toUpperCase).collect(Collectors.toList()));
        return upperList;
    }

    default public String getSuffixName(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        if (StringUtils.isEmpty((Object)originalFilename) || !originalFilename.contains(".")) {
            throw new GaeaOSSException("original file name or type is empty");
        }
        String suffixName = originalFilename.substring(originalFilename.lastIndexOf("."));
        return suffixName;
    }

    default public boolean isAllowedFileSuffixName(MultipartFile file) {
        String sufixwhiteListStr = this.getFileTypeWhiteList();
        if (sufixwhiteListStr == null) {
            return true;
        }
        if (StringUtils.isEmpty((Object)(sufixwhiteListStr = sufixwhiteListStr.trim()))) {
            return true;
        }
        String suffixName = this.getSuffixName(file).toUpperCase();
        List<String> sufixwhiteList = this.splitToList(sufixwhiteListStr);
        return sufixwhiteList.contains(suffixName);
    }

    default public void checkFileSuffixName(MultipartFile file) {
        boolean allowedFileSuffix = this.isAllowedFileSuffixName(file);
        if (!allowedFileSuffix) {
            logger.warn("file {} type is not in allow list {}", (Object)file.getOriginalFilename(), (Object)this.getFileTypeWhiteList());
            throw GaeaOSSTypeLimitedExceptionBuilder.build("file type is not in allow list");
        }
    }

    default public String uploadFileByInputStream(MultipartFile file) throws GaeaOSSException {
        this.checkFileSuffixName(file);
        String suffixName = this.getSuffixName(file);
        String fileId = UUID.randomUUID().toString();
        fileId = fileId.replaceAll("-", "");
        String fileObjectName = fileId + suffixName;
        return this.uploadFileByInputStream(file, fileObjectName);
    }

    public String uploadFileByInputStream(MultipartFile var1, String var2) throws GaeaOSSException;

    public byte[] downloadFile(String var1) throws GaeaOSSException;

    public void deleteFile(String var1);

    public void deleteFiles(List<String> var1);
}

