/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.controller.advice;

import com.anji.plus.gaea.bean.ResponseBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class ResponseBeanAdvice
implements ResponseBodyAdvice<ResponseBean> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBeanAdvice.class);
    @Autowired
    private MessageSource messageSource;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.getParameterType() == ResponseBean.class;
    }

    public ResponseBean beforeBodyWrite(ResponseBean responseBean, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (StringUtils.isNotBlank((CharSequence)responseBean.getMessage())) {
            return responseBean;
        }
        String code = responseBean.getCode();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            try {
                String message = this.messageSource.getMessage(code, responseBean.getArgs(), LocaleContextHolder.getLocale());
                responseBean.setMessage(message);
            }
            catch (Exception e) {
                log.warn("getMessage-err:{}", (Object)code, (Object)e);
                responseBean.setMessage(code);
            }
        }
        return responseBean;
    }
}

