package com.anji.plus.gaea.curd.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wangbin
 */
public interface FieldQueryDialect {

    /***
     * 生成全文检索 表达式
     * @param queryWrapper
     * @param param
     * @param column
     * @param value
     * @return
     */
    default <T> void match(QueryWrapper<T> queryWrapper, Object param, String column, Object value){
        if(Objects.isNull(value)){
            return;
        }
        // 默认 mysql方案,支持输入多个参数查询
        queryWrapper.apply(String.format(" match(%s) against('\"%s\"' in boolean mode) ",column,
                Arrays.stream((value+"").split(" ")).collect(Collectors.joining("\" \""))));
    }
}
