/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetAuthorizersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetAuthorizersRequestMarshaller
implements Marshaller<Request<GetAuthorizersRequest>, GetAuthorizersRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetAuthorizersRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetAuthorizersRequest> marshall(GetAuthorizersRequest getAuthorizersRequest) {
        if (getAuthorizersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getAuthorizersRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", getAuthorizersRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        if (getAuthorizersRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getAuthorizersRequest.getPosition()));
        }
        if (getAuthorizersRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getAuthorizersRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

