/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.command;

import java.io.Serializable;

public class ProcessResponse
implements Serializable {
    private final Object entity;
    private final Boolean success;
    private final String redirect;

    public ProcessResponse(Object entity, Boolean success, String redirect) {
        this.entity = entity;
        this.success = success;
        this.redirect = redirect;
    }

    public static ResponseBuilder ok() {
        return ProcessResponse.setStatus(true);
    }

    public static ResponseBuilder ok(Object entity) {
        ResponseBuilder b = ProcessResponse.ok();
        b.entity(entity);
        return b;
    }

    public static ResponseBuilder fail() {
        return ProcessResponse.setStatus(false);
    }

    public static ResponseBuilder fail(String errorMsg) {
        ResponseBuilder b = ProcessResponse.fail();
        b.entity(errorMsg);
        return b;
    }

    public static ResponseBuilder redirect(String leader) {
        ResponseBuilder b = ProcessResponse.fail();
        b.entity("Not leader");
        b.redirect(leader);
        return b;
    }

    protected static ResponseBuilder setStatus(Boolean status) {
        ResponseBuilder b = new ResponseBuilder();
        b.status(status);
        return b;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public static class ResponseBuilder {
        private Object entity;
        private Boolean success;
        private String redirect;

        public ProcessResponse build() {
            ProcessResponse r = new ProcessResponse(this.entity, this.success, this.redirect);
            this.reset();
            return r;
        }

        private void reset() {
            this.success = null;
            this.entity = null;
            this.redirect = null;
        }

        public ResponseBuilder status(Boolean status) {
            if (status == null) {
                throw new IllegalArgumentException("response status can not be null!");
            }
            this.success = status;
            return this;
        }

        public ResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public ResponseBuilder redirect(String redirect) {
            if (redirect == null) {
                throw new IllegalArgumentException("redirect leader can not be null!");
            }
            this.redirect = redirect;
            return this;
        }
    }
}

