/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.bigquery.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.expr.SQLAtTimeZoneExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLStructExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefault;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLColumnReference;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLNotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.dialect.bigquery.BQ;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryCharExpr;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryModelExpr;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryTableExpr;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQueryLexer;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQuerySelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class BigQueryExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;
    static final long SAFE_CAST;

    public BigQueryExprParser(String sql) {
        this(new BigQueryLexer(sql, new SQLParserFeature[0]));
        this.lexer.nextToken();
    }

    public BigQueryExprParser(String sql, SQLParserFeature ... features) {
        this(new BigQueryLexer(sql, features));
        this.lexer.nextToken();
    }

    public BigQueryExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.bigquery;
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    protected SQLExpr methodRest(SQLExpr expr, boolean acceptLPAREN) {
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            long hashCode64 = identifierExpr.hashCode64();
            if (hashCode64 == FnvHash.Constants.STRUCT && acceptLPAREN) {
                SQLStructExpr struct = this.struct();
                if (this.lexer.isKeepSourceLocation()) {
                    struct.setSource(identifierExpr.getSourceLine(), identifierExpr.getSourceColumn());
                }
                return struct;
            }
            if (hashCode64 == SAFE_CAST && acceptLPAREN) {
                SQLCastExpr castExpr = new SQLCastExpr();
                this.lexer.nextToken();
                castExpr.setExpr(this.expr());
                castExpr.setTry(true);
                this.accept(Token.AS);
                castExpr.setDataType(this.parseDataType());
                castExpr = this.parseCastFormat(castExpr);
                this.accept(Token.RPAREN);
                return castExpr;
            }
            String ident = identifierExpr.getName();
            if (ident.length() > 3 && ident.charAt(0) == '`' && ident.charAt(ident.length() - 1) == '`' && ident.indexOf(46) != -1) {
                expr = this.topPropertyExpr(ident);
            }
        }
        return super.methodRest(expr, acceptLPAREN);
    }

    @Override
    protected SQLExpr parseSelectItemRest(String ident, long hash_lower) {
        if (ident.length() > 3 && ident.charAt(0) == '`' && ident.charAt(ident.length() - 1) == '`' && ident.indexOf(46) != -1) {
            return this.topPropertyExpr(ident);
        }
        if (hash_lower == FnvHash.Constants.ARRAY && this.lexer.token() == Token.LT) {
            return this.parseArrayExpr(ident);
        }
        return null;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.OPTIONS)) {
            this.parseAssignItem(column.getColProperties(), (SQLObject)column);
        }
        return super.parseColumnRest(column);
    }

    @Override
    protected SQLStructDataType parseDataTypeStruct() {
        this.acceptIdentifier("STRUCT");
        return this.parseDataTypeStruct0();
    }

    protected SQLStructDataType parseDataTypeStruct0() {
        SQLStructDataType struct = new SQLStructDataType(this.dbType);
        this.accept(Token.LT);
        while (true) {
            SQLIdentifierExpr name;
            String str;
            if (BQ.DIALECT.isBuiltInDataType(str = this.lexer.stringVal())) {
                String tokenName;
                Lexer.SavePoint mark = this.lexer.markOut();
                this.lexer.nextToken();
                String string = tokenName = this.lexer.token() == Token.IDENTIFIER ? this.lexer.stringVal() : this.lexer.token().name;
                if (tokenName != null && Character.isLetter(tokenName.charAt(0)) && BQ.DIALECT.isBuiltInDataType(this.lexer.stringVal())) {
                    name = new SQLIdentifierExpr(str);
                } else {
                    this.lexer.reset(mark);
                    name = null;
                }
            } else {
                name = new SQLIdentifierExpr(str);
                this.lexer.nextToken();
            }
            SQLDataType dataType = this.parseDataType();
            SQLStructDataType.Field field = struct.addField(name, dataType);
            this.parseFieldConstraints(field);
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.OPTIONS)) {
                this.parseAssignItem(field.getOptions(), (SQLObject)field);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.GTGTGT) {
            this.lexer.setToken(Token.GTGT);
        } else if (this.lexer.token() == Token.GTGT) {
            this.lexer.setToken(Token.GT);
        } else {
            this.accept(Token.GT);
        }
        return struct;
    }

    private void parseFieldConstraints(SQLStructDataType.Field field) {
        switch (this.lexer.token()) {
            case DEFAULT: {
                field.addConstraint(this.parseColumnDefault());
                break;
            }
            case NOT: {
                this.lexer.nextToken();
                this.accept(Token.NULL);
                SQLNotNullConstraint notNull = new SQLNotNullConstraint();
                field.addConstraint(notNull);
                break;
            }
            case PRIMARY: {
                SQLColumnPrimaryKey pk = new SQLColumnPrimaryKey();
                this.lexer.nextToken();
                this.accept(Token.KEY);
                this.accept(Token.NOT);
                this.acceptIdentifier("ENFORCED");
                pk.setNotEnforced(true);
                field.addConstraint(pk);
                break;
            }
            case REFERENCES: {
                SQLColumnReference ref = this.parseReference();
                this.accept(Token.NOT);
                this.acceptIdentifier("ENFORCED");
                ref.setNotEnforced(true);
                field.addConstraint(ref);
                break;
            }
        }
    }

    private SQLColumnDefault parseColumnDefault() {
        SQLColumnDefault columnDefault = new SQLColumnDefault();
        this.accept(Token.DEFAULT);
        if (this.lexer.token() == Token.LPAREN) {
            while (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
            }
            columnDefault.setDefaultExpr(this.primary());
            while (this.lexer.token() == Token.RPAREN) {
                this.accept(Token.RPAREN);
            }
        } else {
            columnDefault.setDefaultExpr(this.primary());
        }
        return columnDefault;
    }

    @Override
    public void parsePrimaryKeyRest(SQLPrimaryKeyImpl primaryKey) {
        this.accept(Token.NOT);
        this.acceptIdentifier("ENFORCED");
        primaryKey.setNotEnforced(true);
        super.parsePrimaryKeyRest(primaryKey);
    }

    @Override
    protected void parseForeignKeyRest(SQLForeignKeyImpl foreignKey) {
        this.accept(Token.NOT);
        this.acceptIdentifier("ENFORCED");
        foreignKey.setNotEnforced(true);
        super.parseForeignKeyRest(foreignKey);
    }

    @Override
    public SQLExpr primary() {
        Lexer.SavePoint mark;
        if (this.lexer.nextIf(Token.DOT)) {
            String name = this.lexer.stringVal();
            SQLExpr expr = new SQLPropertyExpr((SQLExpr)null, name);
            this.lexer.nextToken();
            if (this.lexer.nextIf(Token.DOT)) {
                expr = this.dotRest(expr);
            }
            return this.primaryRest(expr);
        }
        if (this.lexer.token() == Token.WITH) {
            return this.primaryRest(this.parseQueryExpr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MODEL)) {
            mark = this.lexer.markOut();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIER) {
                BigQueryModelExpr model = new BigQueryModelExpr();
                model.setName(this.name());
                return model;
            }
            this.lexer.reset(mark);
        }
        if (this.lexer.token() == Token.TABLE) {
            mark = this.lexer.markOut();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIER) {
                BigQueryTableExpr model = new BigQueryTableExpr();
                model.setName(this.name());
                return model;
            }
            this.lexer.reset(mark);
        }
        return super.primary();
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            String ident = identifierExpr.getName();
            if (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                boolean isSpace;
                boolean isAlias;
                boolean bl = isAlias = this.lexer.token() == Token.LITERAL_ALIAS;
                if (ident.equalsIgnoreCase("b") || ident.equalsIgnoreCase("r")) {
                    isSpace = false;
                } else if (ident.equalsIgnoreCase("json")) {
                    isSpace = true;
                } else {
                    throw new ParserException("Not supported prefix: " + ident + " for bigquery");
                }
                String charValue = this.lexer.stringVal();
                this.lexer.nextToken();
                expr = new BigQueryCharExpr(charValue, ident, isSpace, isAlias);
            }
        }
        Lexer.SavePoint savePoint = this.lexer.markOut();
        if (this.lexer.identifierEquals(FnvHash.Constants.AT)) {
            this.lexer.nextToken();
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.TIME)) {
                this.acceptIdentifier("ZONE");
                SQLExpr timeZone = this.primary();
                expr = new SQLAtTimeZoneExpr(expr, timeZone);
            } else {
                this.lexer.reset(savePoint);
            }
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLDataType parseDataType(boolean restrict) {
        if (this.lexer.nextIf(Token.ANY)) {
            this.acceptIdentifier("TYPE");
            return new SQLDataTypeImpl("ANY TYPE");
        }
        return super.parseDataType(restrict);
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        return super.dotRest(expr);
    }

    @Override
    public SQLSelectParser createSelectParser() {
        return new BigQuerySelectParser(this, null);
    }

    @Override
    public SQLExpr exprRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LT && expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameEquals("STRUCT")) {
            SQLStructExpr structExpr = new SQLStructExpr();
            structExpr.setDataType(this.parseDataTypeStruct0());
            this.accept(Token.LPAREN);
            this.aliasedItems(structExpr.getItems(), structExpr);
            this.accept(Token.RPAREN);
            expr = structExpr;
        }
        return super.exprRest(expr);
    }

    @Override
    protected String nameCommon() {
        String identName = this.lexer.stringVal();
        this.lexer.nextToken();
        return identName;
    }

    @Override
    protected SQLCastExpr parseCastFormat(SQLCastExpr cast) {
        if (this.lexer.nextIfIdentifier("FORMAT")) {
            cast.setFormat(this.expr());
        }
        return cast;
    }

    @Override
    protected SQLExpr primaryIdentifierRest(long hash_lower, String ident) {
        if (ident.length() > 3 && ident.charAt(0) == '`' && ident.charAt(ident.length() - 1) == '`' && ident.indexOf(46) != -1) {
            return this.topPropertyExpr(ident);
        }
        return super.primaryIdentifierRest(hash_lower, ident);
    }

    @Override
    public SQLName nameRest(SQLName name) {
        String ident;
        if (name instanceof SQLIdentifierExpr && (ident = ((SQLIdentifierExpr)name).getName()).length() > 3 && ident.charAt(0) == '`' && ident.charAt(ident.length() - 1) == '`' && ident.indexOf(46) != -1) {
            return this.topPropertyExpr(ident);
        }
        return super.nameRest(name);
    }

    @Override
    protected SQLExpr primaryCommon(SQLExpr sqlExpr) {
        sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
        this.lexer.nextToken();
        return sqlExpr;
    }

    static {
        String[] strings = new String[]{"ANY_VALUE", "ARRAY_AGG", "ARRAY_CONCAT_AGG", "AVG", "BIT_AND", "BIT_OR", "BIT_XOR", "COUNT", "COUNTIF", "FIRST_VALUE", "GROUPING", "LAST_VALUE", "LAG", "LEAD", "LOGICAL_AND", "LOGICAL_OR", "MAX", "MAX_BY", "MIN", "MIN_BY", "STRING_AGG", "SUM", "APPROX_QUANTILES"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            BigQueryExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
        SAFE_CAST = FnvHash.fnv1a_64_lower("SAFE_CAST");
    }
}

