/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads;

import com.alibaba.dashscope.api.GeneralApi;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.DeletionStatus;
import com.alibaba.dashscope.common.FlattenResultBase;
import com.alibaba.dashscope.common.GeneralGetParam;
import com.alibaba.dashscope.common.UpdateMetadataParam;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.GeneralServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.threads.AssistantThread;
import com.alibaba.dashscope.threads.ThreadParam;

public final class Threads {
    private final GeneralApi<HalfDuplexParamBase> api;
    private final GeneralServiceOption serviceOption = this.defaultServiceOption();

    private GeneralServiceOption defaultServiceOption() {
        return ((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)GeneralServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).path("threads")).build();
    }

    public Threads() {
        this.api = new GeneralApi();
    }

    public Threads(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption.setBaseHttpUrl(baseUrl);
        this.api = new GeneralApi(connectionOptions);
    }

    public AssistantThread create(ThreadParam param) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads", new Object[0]));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (AssistantThread)FlattenResultBase.fromDashScopeResult(result, AssistantThread.class);
    }

    public AssistantThread update(String threadId, UpdateMetadataParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.equals("")) {
            throw new InputRequiredException("threadId is required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s", threadId));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (AssistantThread)FlattenResultBase.fromDashScopeResult(result, AssistantThread.class);
    }

    public AssistantThread retrieve(String threadId) throws ApiException, NoApiKeyException {
        return this.retrieve(threadId, null);
    }

    public AssistantThread retrieve(String threadId, String apiKey) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s", threadId));
        DashScopeResult result = this.api.get(((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().apiKey(apiKey)).build(), this.serviceOption);
        return (AssistantThread)FlattenResultBase.fromDashScopeResult(result, AssistantThread.class);
    }

    public DeletionStatus delete(String threadId) throws ApiException, NoApiKeyException {
        return this.delete(threadId, null);
    }

    public DeletionStatus delete(String threadId, String apiKey) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.DELETE);
        this.serviceOption.setPath(String.format("threads/%s", threadId));
        DashScopeResult result = this.api.delete(((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().apiKey(apiKey)).build(), this.serviceOption);
        return (DeletionStatus)FlattenResultBase.fromDashScopeResult(result, DeletionStatus.class);
    }
}

