/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.ChainStatus;
import com.agentsflex.core.chain.NodeContext;
import com.agentsflex.core.chain.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChainHolder
implements Serializable {
    private String id;
    private String name;
    private String description;
    private ChainHolder parent;
    private List<ChainHolder> children;
    private List<ChainNode> nodes;
    private List<ChainEdge> edges;
    private Map<String, Object> executeResult;
    private Map<String, NodeContext> nodeContexts;
    private List<ChainNode> suspendNodes;
    private List<Parameter> suspendForParameters;
    private ChainStatus status;
    private String message;

    public static ChainHolder fromChain(Chain chain) {
        ChainHolder holder = new ChainHolder();
        holder.id = chain.getId();
        holder.name = chain.getName();
        holder.description = chain.getDescription();
        holder.parent = chain.getParent() == null ? null : ChainHolder.fromChain(chain.getParent());
        holder.children = chain.getChildren() == null ? null : chain.getChildren().stream().map(ChainHolder::fromChain).collect(Collectors.toList());
        holder.nodes = chain.getNodes();
        holder.edges = chain.getEdges();
        holder.executeResult = chain.getExecuteResult();
        holder.nodeContexts = chain.getNodeContexts();
        holder.suspendNodes = chain.getSuspendNodes();
        holder.suspendForParameters = chain.getSuspendForParameters();
        holder.status = chain.getStatus();
        holder.message = chain.getMessage();
        return holder;
    }

    public static ChainHolder fromJSON(String jsonString) {
        return (ChainHolder)JSON.parseObject((String)jsonString, ChainHolder.class, (Feature[])new Feature[]{Feature.SupportAutoType});
    }

    public String toJSON() {
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
    }

    public Chain toChain() {
        return new Chain(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ChainHolder getParent() {
        return this.parent;
    }

    public void setParent(ChainHolder parent) {
        this.parent = parent;
    }

    public List<ChainHolder> getChildren() {
        return this.children;
    }

    public void setChildren(List<ChainHolder> children) {
        this.children = children;
    }

    public List<ChainNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ChainNode> nodes) {
        this.nodes = nodes;
    }

    public List<ChainEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<ChainEdge> edges) {
        this.edges = edges;
    }

    public Map<String, Object> getExecuteResult() {
        return this.executeResult;
    }

    public void setExecuteResult(Map<String, Object> executeResult) {
        this.executeResult = executeResult;
    }

    public Map<String, NodeContext> getNodeContexts() {
        return this.nodeContexts;
    }

    public void setNodeContexts(Map<String, NodeContext> nodeContexts) {
        this.nodeContexts = nodeContexts;
    }

    public List<ChainNode> getSuspendNodes() {
        return this.suspendNodes;
    }

    public void setSuspendNodes(List<ChainNode> suspendNodes) {
        this.suspendNodes = suspendNodes;
    }

    public List<Parameter> getSuspendForParameters() {
        return this.suspendForParameters;
    }

    public void setSuspendForParameters(List<Parameter> suspendForParameters) {
        this.suspendForParameters = suspendForParameters;
    }

    public ChainStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChainStatus status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return "ChainHolder{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", parent=" + this.parent + ", children=" + this.children + ", nodes=" + this.nodes + ", edges=" + this.edges + ", executeResult=" + this.executeResult + ", nodeContexts=" + this.nodeContexts + ", suspendNodes=" + this.suspendNodes + ", suspendForParameters=" + this.suspendForParameters + ", status=" + (Object)((Object)this.status) + ", message='" + this.message + '\'' + '}';
    }
}

