/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.contact.department.Department;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;

/**
 * Auto generate interface of DepartmentApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface DepartmentClient {

    /**
     * update
     *
     * @param corpId
     * @param department
     * @throws WeworkException
     */
    void update(String corpId, Department department) throws WeworkException;

    /**
     * delete
     *
     * @param corpId
     * @param id
     * @throws WeworkException
     */
    void delete(String corpId, Integer id) throws WeworkException;

    /**
     * create
     *
     * @param corpId
     * @param department
     * @return Integer
     * @throws WeworkException
     */
    Integer create(String corpId, Department department) throws WeworkException;

    /**
     * list
     *
     * @param corpId
     * @param id
     * @return List<Department>
     * @throws WeworkException
     */
    List<Department> list(String corpId, Integer id) throws WeworkException;

}