/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.statistic.BehaviorData;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupChatStatisticParam;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupStatisticResult;
import cn.kinyun.wework.sdk.entity.external.statistic.UserBehaviorParams;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;

/**
 * Auto generate interface of ExternalStatisticApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface ExternalStatisticClient {

    /**
     * getUserBehaviorData
     *
     * @param corpId
     * @param userBehaviorParams
     * @return List<BehaviorData>
     * @throws WeworkException
     */
    List<BehaviorData> getUserBehaviorData(String corpId, UserBehaviorParams userBehaviorParams) throws WeworkException;

    /**
     * getGroupStatisticData
     *
     * @param corpId
     * @param groupChatStatisticParam
     * @return GroupStatisticResult
     * @throws WeworkException
     */
    GroupStatisticResult getGroupStatisticData(String corpId, GroupChatStatisticParam groupChatStatisticParam) throws WeworkException;

}