/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;

/**
 * Auto generate interface of ContactWayApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface ContactWayClient {

    /**
     * getFollowUserList
     *
     * @param corpId
     * @return List<String>
     * @throws WeworkException
     */
    List<String> getFollowUserList(String corpId) throws WeworkException;

    /**
     * get
     *
     * @param corpId
     * @param configId
     * @return ContactWay
     * @throws WeworkException
     */
    ContactWay get(String corpId, String configId) throws WeworkException;

    /**
     * update
     *
     * @param corpId
     * @param contactWay
     * @throws WeworkException
     */
    void update(String corpId, ContactWay contactWay) throws WeworkException;

    /**
     * 异步调用update
     *
     * @param corpId
     * @param contactWay
     * @return requestId
     */
    String asyncUpdate(String corpId, ContactWay contactWay);

    /**
     * delete
     *
     * @param corpId
     * @param configId
     * @throws WeworkException
     */
    void delete(String corpId, String configId) throws WeworkException;

    /**
     * 异步调用delete
     *
     * @param corpId
     * @param configId
     * @return requestId
     */
    String asyncDelete(String corpId, String configId);

    /**
     * create
     *
     * @param corpId
     * @param params
     * @return ConfigIdResp
     * @throws WeworkException
     */
    ConfigIdResp create(String corpId, ContactWay params) throws WeworkException;

    /**
     * 异步调用create
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncCreate(String corpId, ContactWay params);

}