/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.Ticket;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of JsSdkApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface JsSdkClient {

    /**
     * getAgentTicket
     *
     * @param corpId
     * @return Ticket
     * @throws WeworkException
     */
    Ticket getAgentTicket(String corpId) throws WeworkException;

    /**
     * getTicketByType
     *
     * @param corpId
     * @param type
     * @return Ticket
     * @throws WeworkException
     */
    Ticket getTicketByType(String corpId, String type) throws WeworkException;

    /**
     * getJsapiTicket
     *
     * @param corpId
     * @return Ticket
     * @throws WeworkException
     */
    Ticket getJsapiTicket(String corpId) throws WeworkException;

}